/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.I18nInterceptor;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

public class I18nInterceptor
extends com.opensymphony.xwork2.interceptor.I18nInterceptor {
    private static final long serialVersionUID = 4587460933182760358L;
    public static final String DEFAULT_COOKIE_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String COOKIE_STORAGE = "cookie";
    public static final String DEFAULT_COOKIE_PARAMETER = "request_cookie_locale";
    protected String requestCookieParameterName = "request_cookie_locale";

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept '{}/{}' {", new Object[]{invocation.getProxy().getNamespace(), invocation.getProxy().getActionName()});
        }
        CookieLocaleFinder localeFinder = new CookieLocaleFinder(invocation);
        Locale locale = this.getLocaleFromParam(localeFinder.getRequestedLocale());
        locale = this.storeLocale(invocation, locale, localeFinder.getStorage());
        this.saveLocale(invocation, locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("before Locale={}", new Object[]{invocation.getStack().findValue("locale")});
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("after Locale={}", new Object[]{invocation.getStack().findValue("locale")});
            LOG.debug("intercept } ");
        }
        return result;
    }

    @Override
    protected Locale storeLocale(ActionInvocation invocation, Locale locale, String storage) {
        if (COOKIE_STORAGE.equals(storage)) {
            ActionContext ac = invocation.getInvocationContext();
            HttpServletResponse response = (HttpServletResponse)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            Cookie cookie = new Cookie(DEFAULT_COOKIE_ATTRIBUTE, locale.toString());
            cookie.setMaxAge(1209600);
            response.addCookie(cookie);
            storage = I18nInterceptor.Storage.SESSION.toString();
        }
        return super.storeLocale(invocation, locale, storage);
    }

    @Override
    protected Locale readStoredLocale(ActionInvocation invocation, Map<String, Object> session) {
        Locale locale = this.readStoredLocalFromSession(invocation, session);
        if (locale != null) {
            return locale;
        }
        Cookie[] cookies = ServletActionContext.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!DEFAULT_COOKIE_ATTRIBUTE.equals(cookie.getName())) continue;
                return this.getLocaleFromParam(cookie.getValue());
            }
        }
        return this.readStoredLocalFromCurrentInvocation(invocation);
    }

    public void setRequestCookieParameterName(String requestCookieParameterName) {
        this.requestCookieParameterName = requestCookieParameterName;
    }

    protected class CookieLocaleFinder
    extends I18nInterceptor.LocaleFinder {
        protected CookieLocaleFinder(ActionInvocation invocation) {
            super(I18nInterceptor.this, invocation);
        }

        @Override
        protected void find() {
            Map<String, Object> params = this.actionInvocation.getInvocationContext().getParameters();
            this.storage = I18nInterceptor.Storage.SESSION.toString();
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.parameterName);
            if (this.requestedLocale != null) {
                return;
            }
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestCookieParameterName);
            if (this.requestedLocale != null) {
                this.storage = I18nInterceptor.COOKIE_STORAGE;
                return;
            }
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestOnlyParameterName);
            if (this.requestedLocale != null) {
                this.storage = I18nInterceptor.Storage.NONE.toString();
            }
        }
    }
}

