/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.views.xslt.AbstractAdapterNode;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ProxyNodeAdapter
extends AbstractAdapterNode {
    private Logger log = LogManager.getLogger(this.getClass());

    public ProxyNodeAdapter(AdapterFactory factory, AdapterNode parent, Node value) {
        this.setContext(factory, parent, "document", value);
        this.log.debug("Proxied node is: {}" + value);
        this.log.debug("Node class is: {}", new Object[]{value.getClass()});
        this.log.debug("Node type is: {}", new Object[]{value.getNodeType()});
        this.log.debug("Node name is: {}", new Object[]{value.getNodeName()});
    }

    protected Node node() {
        return (Node)this.getPropertyValue();
    }

    protected Node wrap(Node node) {
        return this.getAdapterFactory().proxyNode(this, node);
    }

    protected NamedNodeMap wrap(NamedNodeMap nnm) {
        return this.getAdapterFactory().proxyNamedNodeMap(this, nnm);
    }

    @Override
    public String getNodeName() {
        this.log.trace("getNodeName");
        return this.node().getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        this.log.trace("getNodeValue");
        return this.node().getNodeValue();
    }

    @Override
    public short getNodeType() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("getNodeType: " + this.getNodeName() + ": " + this.node().getNodeType());
        }
        return this.node().getNodeType();
    }

    @Override
    public NamedNodeMap getAttributes() {
        NamedNodeMap nnm = this.wrap(this.node().getAttributes());
        if (this.log.isTraceEnabled()) {
            this.log.trace("getAttributes: " + nnm);
        }
        return nnm;
    }

    @Override
    public boolean hasChildNodes() {
        this.log.trace("hasChildNodes");
        return this.node().hasChildNodes();
    }

    @Override
    public boolean isSupported(String s, String s1) {
        this.log.trace("isSupported");
        return this.node().isSupported(s, s1);
    }

    @Override
    public String getNamespaceURI() {
        this.log.trace("getNamespaceURI");
        return this.node().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        this.log.trace("getPrefix");
        return this.node().getPrefix();
    }

    @Override
    public String getLocalName() {
        this.log.trace("getLocalName");
        return this.node().getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        this.log.trace("hasAttributes");
        return this.node().hasAttributes();
    }

    @Override
    public String toString() {
        return "ProxyNode for: " + this.node();
    }
}

