/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServletURIResolver
implements URIResolver {
    private Logger log = LogManager.getLogger(this.getClass());
    static final String PROTOCOL = "response:";
    private ServletContext sc;

    public ServletURIResolver(ServletContext sc) {
        this.log.trace("ServletURIResolver: {}", new Object[]{sc});
        this.sc = sc;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        this.log.debug("ServletURIResolver resolve(): href={}, base={}", new Object[]{href, base});
        if (href.startsWith(PROTOCOL)) {
            String res = href.substring(PROTOCOL.length());
            this.log.debug("Resolving resource <{}>", new Object[]{res});
            InputStream is = this.sc.getResourceAsStream(res);
            if (is == null) {
                throw new TransformerException("Resource " + res + " not found in resources.");
            }
            return new StreamSource(is);
        }
        throw new TransformerException("Cannot handle protocol of resource " + href);
    }
}

