/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimerInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(TimerInterceptor.class);
    protected Logger categoryLogger;
    protected String logCategory;
    protected String logLevel;

    public String getLogCategory() {
        return this.logCategory;
    }

    public void setLogCategory(String logCatgory) {
        this.logCategory = logCatgory;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (!this.shouldLog()) {
            return invocation.invoke();
        }
        return this.invokeUnderTiming(invocation);
    }

    protected String invokeUnderTiming(ActionInvocation invocation) throws Exception {
        long startTime = System.currentTimeMillis();
        String result = invocation.invoke();
        long executionTime = System.currentTimeMillis() - startTime;
        StringBuilder message = new StringBuilder(100);
        message.append("Executed action [");
        String namespace = invocation.getProxy().getNamespace();
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            message.append(namespace).append("/");
        }
        message.append(invocation.getProxy().getActionName());
        message.append("!");
        message.append(invocation.getProxy().getMethod());
        message.append("] took ").append(executionTime).append(" ms.");
        this.doLog(this.getLoggerToUse(), message.toString());
        return result;
    }

    protected boolean shouldLog() {
        if (this.logLevel == null && this.logCategory == null) {
            return LOG.isInfoEnabled();
        }
        return TimerInterceptor.isLoggerEnabled(this.getLoggerToUse(), this.logLevel);
    }

    protected Logger getLoggerToUse() {
        if (this.logCategory != null) {
            if (this.categoryLogger == null) {
                this.categoryLogger = LogManager.getLogger((String)this.logCategory);
                if (this.logLevel == null) {
                    this.logLevel = "info";
                }
            }
            return this.categoryLogger;
        }
        return LOG;
    }

    protected void doLog(Logger logger, String message) {
        if (this.logLevel == null) {
            logger.info(message);
            return;
        }
        if ("debug".equalsIgnoreCase(this.logLevel)) {
            logger.debug(message);
        } else if ("info".equalsIgnoreCase(this.logLevel)) {
            logger.info(message);
        } else if ("warn".equalsIgnoreCase(this.logLevel)) {
            logger.warn(message);
        } else if ("error".equalsIgnoreCase(this.logLevel)) {
            logger.error(message);
        } else if ("fatal".equalsIgnoreCase(this.logLevel)) {
            logger.fatal(message);
        } else if ("trace".equalsIgnoreCase(this.logLevel)) {
            logger.trace(message);
        } else {
            throw new IllegalArgumentException("LogLevel [" + this.logLevel + "] is not supported");
        }
    }

    private static boolean isLoggerEnabled(Logger logger, String level) {
        if ("debug".equalsIgnoreCase(level)) {
            return logger.isDebugEnabled();
        }
        if ("info".equalsIgnoreCase(level)) {
            return logger.isInfoEnabled();
        }
        if ("warn".equalsIgnoreCase(level)) {
            return logger.isWarnEnabled();
        }
        if ("error".equalsIgnoreCase(level)) {
            return logger.isErrorEnabled();
        }
        if ("fatal".equalsIgnoreCase(level)) {
            return logger.isFatalEnabled();
        }
        if ("trace".equalsIgnoreCase(level)) {
            return logger.isTraceEnabled();
        }
        throw new IllegalArgumentException("LogLevel [" + level + "] is not supported");
    }
}

