/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.struts2.dispatcher.Parameter;

public class HttpParameters
implements Cloneable {
    private Map<String, Parameter> parameters;

    private HttpParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public static Builder create(Map requestParameterMap) {
        return new Builder(requestParameterMap);
    }

    public static Builder create() {
        return new Builder(new HashMap());
    }

    public Parameter get(String name) {
        if (this.parameters.containsKey(name)) {
            return this.parameters.get(name);
        }
        return new Parameter.EmptyHttpParameter(name);
    }

    public Set<String> getNames() {
        return new TreeSet<String>(this.parameters.keySet());
    }

    public HttpParameters remove(Set<String> paramsToRemove) {
        for (String paramName : paramsToRemove) {
            this.parameters.remove(paramName);
        }
        return this;
    }

    public HttpParameters remove(final String paramToRemove) {
        return this.remove((Set<String>)new HashSet<String>(){
            {
                this.add(paramToRemove);
            }
        });
    }

    public boolean contains(String name) {
        return this.parameters.containsKey(name);
    }

    public Map<String, String[]> toMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>(this.parameters.size());
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getMultipleValues());
        }
        return result;
    }

    public HttpParameters appendAll(Map<String, Parameter> newParams) {
        this.parameters.putAll(newParams);
        return this;
    }

    public static class Builder {
        private Map<String, Object> requestParameterMap = new HashMap<String, Object>();
        private HttpParameters parent;

        protected Builder(Map<String, ?> requestParameterMap) {
            this.requestParameterMap.putAll(requestParameterMap);
        }

        public Builder withParent(HttpParameters parentParams) {
            if (parentParams != null) {
                this.parent = parentParams;
            }
            return this;
        }

        public Builder withExtraParams(Map<String, ?> params) {
            if (params != null) {
                this.requestParameterMap.putAll(params);
            }
            return this;
        }

        public Builder withComparator(Comparator<String> orderedComparator) {
            this.requestParameterMap = new TreeMap<String, Object>(orderedComparator);
            return this;
        }

        public HttpParameters build() {
            HashMap<String, Parameter.Request> parameters = this.parent == null ? new HashMap<String, Parameter.Request>() : new HashMap(this.parent.parameters);
            for (Map.Entry<String, Object> entry : this.requestParameterMap.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                parameters.put(name, new Parameter.Request(name, value));
            }
            return new HttpParameters(parameters);
        }
    }
}

