/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;

public class CheckboxInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -586878104807229585L;
    private String uncheckedValue = Boolean.FALSE.toString();
    private static final Logger LOG = LogManager.getLogger(CheckboxInterceptor.class);

    @Override
    public String intercept(ActionInvocation ai) throws Exception {
        HttpParameters parameters = ai.getInvocationContext().getParameters();
        HashMap<String, Parameter> extraParams = new HashMap<String, Parameter>();
        for (String name : parameters.getNames()) {
            if (!name.startsWith("__checkbox_")) continue;
            String checkboxName = name.substring("__checkbox_".length());
            Parameter value = parameters.get(name);
            parameters = parameters.remove(name);
            if (value.isMultiple()) {
                LOG.debug("Bypassing automatic checkbox detection due to multiple checkboxes of the same name: {}", (Object)name);
                continue;
            }
            if (parameters.contains(checkboxName)) continue;
            extraParams.put(checkboxName, new Parameter.Request(checkboxName, this.uncheckedValue));
        }
        ai.getInvocationContext().getParameters().appendAll(extraParams);
        return ai.invoke();
    }

    public void setUncheckedValue(String uncheckedValue) {
        this.uncheckedValue = uncheckedValue;
    }
}

