/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;

public class I18nInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    public static final String DEFAULT_REQUESTONLY_PARAMETER = "request_only_locale";
    public static final String DEFAULT_COOKIE_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_COOKIE_PARAMETER = "request_cookie_locale";
    protected String parameterName = "request_locale";
    protected String requestOnlyParameterName = "request_only_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";
    protected LocaleProvider localeProvider;
    protected String requestCookieParameterName = "request_cookie_locale";

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setRequestOnlyParameterName(String requestOnlyParameterName) {
        this.requestOnlyParameterName = requestOnlyParameterName;
    }

    public void setRequestCookieParameterName(String requestCookieParameterName) {
        this.requestCookieParameterName = requestCookieParameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Inject
    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept '{}/{}' {", (Object)invocation.getProxy().getNamespace(), (Object)invocation.getProxy().getActionName());
        }
        CookieLocaleFinder localeFinder = new CookieLocaleFinder(invocation);
        Locale locale = this.getLocaleFromParam(localeFinder.getRequestedLocale());
        locale = this.storeLocale(invocation, locale, localeFinder.getStorage());
        this.saveLocale(invocation, locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("before Locale={}", invocation.getStack().findValue("locale"));
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("after Locale={}", invocation.getStack().findValue("locale"));
            LOG.debug("intercept } ");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Locale storeLocale(ActionInvocation invocation, Locale locale, Storage storage) {
        Map<String, Object> session;
        if (storage == Storage.COOKIE) {
            ActionContext ac = invocation.getInvocationContext();
            HttpServletResponse response = (HttpServletResponse)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            Cookie cookie = new Cookie("WW_TRANS_I18N_LOCALE", locale.toString());
            cookie.setMaxAge(1209600);
            response.addCookie(cookie);
            storage = Storage.SESSION;
        }
        if ((session = invocation.getInvocationContext().getSession()) != null) {
            Map<String, Object> map = session;
            synchronized (map) {
                if (locale == null) {
                    storage = Storage.NONE;
                    locale = this.readStoredLocale(invocation, session);
                }
                if (Storage.SESSION == storage) {
                    session.put(this.attributeName, locale);
                }
            }
        }
        return locale;
    }

    protected Locale readStoredLocale(ActionInvocation invocation, Map<String, Object> session) {
        Locale locale = this.readStoredLocalFromSession(invocation, session);
        if (locale != null) {
            return locale;
        }
        Cookie[] cookies = ServletActionContext.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"WW_TRANS_I18N_LOCALE".equals(cookie.getName())) continue;
                return this.getLocaleFromParam(cookie.getValue());
            }
        }
        return this.readStoredLocalFromCurrentInvocation(invocation);
    }

    protected Locale getLocaleFromParam(Object requestedLocale) {
        Locale locale = null;
        if (requestedLocale != null) {
            if (requestedLocale instanceof Locale) {
                locale = (Locale)requestedLocale;
            } else {
                String localeStr = requestedLocale.toString();
                if (this.localeProvider.isValidLocaleString(localeStr)) {
                    locale = LocalizedTextUtil.localeFromString(requestedLocale.toString(), null);
                }
            }
            if (locale != null) {
                LOG.debug("Applied request locale: {}", (Object)locale);
            }
        }
        if (locale != null && !this.localeProvider.isValidLocale(locale)) {
            Locale defaultLocale = this.localeProvider.getLocale();
            LOG.debug("Provided locale {} isn't valid, fallback to default locale", (Object)locale, (Object)defaultLocale);
            locale = defaultLocale;
        }
        return locale;
    }

    protected Locale readStoredLocalFromSession(ActionInvocation invocation, Map<String, Object> session) {
        Object sessionLocale = session.get(this.attributeName);
        if (sessionLocale != null && sessionLocale instanceof Locale) {
            Locale locale = (Locale)sessionLocale;
            LOG.debug("Applied session locale: {}", (Object)locale);
            return locale;
        }
        return null;
    }

    protected Locale readStoredLocalFromCurrentInvocation(ActionInvocation invocation) {
        Locale locale = invocation.getInvocationContext().getLocale();
        if (locale != null) {
            LOG.debug("Applied invocation context locale: {}", (Object)locale);
        }
        return locale;
    }

    protected Parameter findLocaleParameter(HttpParameters params, String parameterName) {
        Parameter requestedLocale = params.get(parameterName);
        params.remove(parameterName);
        if (requestedLocale.isDefined()) {
            LOG.debug("Requested locale: {}", (Object)requestedLocale.getValue());
        }
        return requestedLocale;
    }

    protected void saveLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }

    protected class CookieLocaleFinder
    extends LocaleFinder {
        protected CookieLocaleFinder(ActionInvocation invocation) {
            super(invocation);
        }

        @Override
        protected void find() {
            HttpParameters params = this.actionInvocation.getInvocationContext().getParameters();
            this.storage = Storage.SESSION;
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.parameterName);
            if (this.requestedLocale.isDefined()) {
                return;
            }
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestCookieParameterName);
            if (this.requestedLocale.isDefined()) {
                this.storage = Storage.COOKIE;
                return;
            }
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestOnlyParameterName);
            if (this.requestedLocale.isDefined()) {
                this.storage = Storage.NONE;
            }
        }
    }

    protected class LocaleFinder {
        protected Storage storage = Storage.SESSION;
        protected Parameter requestedLocale = null;
        protected ActionInvocation actionInvocation = null;

        protected LocaleFinder(ActionInvocation invocation) {
            this.actionInvocation = invocation;
            this.find();
        }

        protected void find() {
            HttpParameters params = this.actionInvocation.getInvocationContext().getParameters();
            this.storage = Storage.SESSION;
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.parameterName);
            if (this.requestedLocale.isDefined()) {
                return;
            }
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestOnlyParameterName);
            if (this.requestedLocale.isDefined()) {
                this.storage = Storage.NONE;
            }
        }

        public Storage getStorage() {
            return this.storage;
        }

        public String getRequestedLocale() {
            return this.requestedLocale.getValue();
        }
    }

    protected static enum Storage {
        COOKIE,
        SESSION,
        NONE;

    }
}

