/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.FileManagerFactoryProvider;
import com.opensymphony.xwork2.config.FileManagerProvider;
import com.opensymphony.xwork2.config.ServletContextAwareConfigurationProvider;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationUtils;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.config.DefaultBeanSelectionProvider;
import org.apache.struts2.config.DefaultPropertiesProvider;
import org.apache.struts2.config.PropertiesConfigurationProvider;
import org.apache.struts2.config.StrutsXmlConfigurationProvider;
import org.apache.struts2.dispatcher.ApplicationMap;
import org.apache.struts2.dispatcher.ContainerHolder;
import org.apache.struts2.dispatcher.DispatcherErrorHandler;
import org.apache.struts2.dispatcher.DispatcherListener;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.RequestMap;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.dispatcher.StrutsRequestWrapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.util.AttributeMap;
import org.apache.struts2.util.ObjectFactoryDestroyable;
import org.apache.struts2.util.fs.JBossFileManager;

public class Dispatcher {
    private static final Logger LOG = LogManager.getLogger(Dispatcher.class);
    private static ThreadLocal<Dispatcher> instance = new ThreadLocal();
    private static List<DispatcherListener> dispatcherListeners = new CopyOnWriteArrayList<DispatcherListener>();
    private boolean devMode;
    private boolean disableRequestAttributeValueStackLookup;
    private String defaultEncoding;
    private String defaultLocale;
    private String multipartSaveDir;
    private String multipartHandlerName;
    private static final String DEFAULT_CONFIGURATION_PATHS = "struts-default.xml,struts-plugin.xml,struts.xml";
    private boolean paramsWorkaroundEnabled = false;
    private boolean handleException;
    private DispatcherErrorHandler errorHandler;
    protected ConfigurationManager configurationManager;
    private ValueStackFactory valueStackFactory;
    protected ServletContext servletContext;
    protected Map<String, String> initParams;

    public static Dispatcher getInstance() {
        return instance.get();
    }

    public static void setInstance(Dispatcher instance) {
        Dispatcher.instance.set(instance);
    }

    public static void addDispatcherListener(DispatcherListener listener) {
        dispatcherListeners.add(listener);
    }

    public static void removeDispatcherListener(DispatcherListener listener) {
        dispatcherListeners.remove(listener);
    }

    public Dispatcher(ServletContext servletContext, Map<String, String> initParams) {
        this.servletContext = servletContext;
        this.initParams = initParams;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = Boolean.parseBoolean(mode);
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    @Inject(value="struts.disableRequestAttributeValueStackLookup", required=false)
    public void setDisableRequestAttributeValueStackLookup(String disableRequestAttributeValueStackLookup) {
        this.disableRequestAttributeValueStackLookup = BooleanUtils.toBoolean((String)disableRequestAttributeValueStackLookup);
    }

    @Inject(value="struts.locale", required=false)
    public void setDefaultLocale(String val) {
        this.defaultLocale = val;
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }

    @Inject(value="struts.multipart.saveDir")
    public void setMultipartSaveDir(String val) {
        this.multipartSaveDir = val;
    }

    @Inject(value="struts.multipart.parser")
    public void setMultipartHandler(String val) {
        this.multipartHandlerName = val;
    }

    @Inject
    public void setValueStackFactory(ValueStackFactory valueStackFactory) {
        this.valueStackFactory = valueStackFactory;
    }

    @Inject(value="struts.handle.exception")
    public void setHandleException(String handleException) {
        this.handleException = Boolean.parseBoolean(handleException);
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    @Inject
    public void setDispatcherErrorHandler(DispatcherErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void cleanup() {
        ObjectFactory objectFactory = this.getContainer().getInstance(ObjectFactory.class);
        if (objectFactory == null) {
            LOG.warn("Object Factory is null, something is seriously wrong, no clean up will be performed");
        }
        if (objectFactory instanceof ObjectFactoryDestroyable) {
            try {
                ((ObjectFactoryDestroyable)((Object)objectFactory)).destroy();
            }
            catch (Exception e) {
                LOG.error("Exception occurred while destroying ObjectFactory [{}]", (Object)objectFactory.toString(), (Object)e);
            }
        }
        instance.set(null);
        if (!dispatcherListeners.isEmpty()) {
            for (DispatcherListener l : dispatcherListeners) {
                l.dispatcherDestroyed(this);
            }
        }
        HashSet<Interceptor> interceptors = new HashSet<Interceptor>();
        Collection<PackageConfig> packageConfigs = this.configurationManager.getConfiguration().getPackageConfigs().values();
        for (PackageConfig packageConfig : packageConfigs) {
            for (Object config : packageConfig.getAllInterceptorConfigs().values()) {
                if (!(config instanceof InterceptorStackConfig)) continue;
                for (InterceptorMapping interceptorMapping : ((InterceptorStackConfig)config).getInterceptors()) {
                    interceptors.add(interceptorMapping.getInterceptor());
                }
            }
        }
        for (Interceptor interceptor : interceptors) {
            interceptor.destroy();
        }
        ContainerHolder.clear();
        ActionContext.setContext(null);
        this.configurationManager.destroyConfiguration();
        this.configurationManager = null;
    }

    private void init_FileManager() throws ClassNotFoundException {
        if (this.initParams.containsKey("struts.fileManager")) {
            String fileManagerClassName = this.initParams.get("struts.fileManager");
            Class<?> fileManagerClass = Class.forName(fileManagerClassName);
            LOG.info("Custom FileManager specified: {}", (Object)fileManagerClassName);
            this.configurationManager.addContainerProvider(new FileManagerProvider(fileManagerClass, fileManagerClass.getSimpleName()));
        } else {
            this.configurationManager.addContainerProvider(new FileManagerProvider(JBossFileManager.class, "jboss"));
        }
        if (this.initParams.containsKey("struts.fileManagerFactory")) {
            String fileManagerFactoryClassName = this.initParams.get("struts.fileManagerFactory");
            Class<?> fileManagerFactoryClass = Class.forName(fileManagerFactoryClassName);
            LOG.info("Custom FileManagerFactory specified: {}", (Object)fileManagerFactoryClassName);
            this.configurationManager.addContainerProvider(new FileManagerFactoryProvider(fileManagerFactoryClass));
        }
    }

    private void init_DefaultProperties() {
        this.configurationManager.addContainerProvider(new DefaultPropertiesProvider());
    }

    private void init_LegacyStrutsProperties() {
        this.configurationManager.addContainerProvider(new PropertiesConfigurationProvider());
    }

    private void init_TraditionalXmlConfigurations() {
        String[] files;
        String configPaths = this.initParams.get("config");
        if (configPaths == null) {
            configPaths = DEFAULT_CONFIGURATION_PATHS;
        }
        for (String file : files = configPaths.split("\\s*[,]\\s*")) {
            if (file.endsWith(".xml")) {
                if ("xwork.xml".equals(file)) {
                    this.configurationManager.addContainerProvider(this.createXmlConfigurationProvider(file, false));
                    continue;
                }
                this.configurationManager.addContainerProvider(this.createStrutsXmlConfigurationProvider(file, false, this.servletContext));
                continue;
            }
            throw new IllegalArgumentException("Invalid configuration file name");
        }
    }

    protected XmlConfigurationProvider createXmlConfigurationProvider(String filename, boolean errorIfMissing) {
        return new XmlConfigurationProvider(filename, errorIfMissing);
    }

    protected XmlConfigurationProvider createStrutsXmlConfigurationProvider(String filename, boolean errorIfMissing, ServletContext ctx) {
        return new StrutsXmlConfigurationProvider(filename, errorIfMissing, ctx);
    }

    private void init_CustomConfigurationProviders() {
        String configProvs = this.initParams.get("configProviders");
        if (configProvs != null) {
            String[] classes;
            for (String cname : classes = configProvs.split("\\s*[,]\\s*")) {
                try {
                    Class cls = ClassLoaderUtil.loadClass(cname, this.getClass());
                    ConfigurationProvider prov = (ConfigurationProvider)cls.newInstance();
                    if (prov instanceof ServletContextAwareConfigurationProvider) {
                        ((ServletContextAwareConfigurationProvider)prov).initWithContext(this.servletContext);
                    }
                    this.configurationManager.addContainerProvider(prov);
                }
                catch (InstantiationException e) {
                    throw new ConfigurationException("Unable to instantiate provider: " + cname, e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("Unable to access provider: " + cname, e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Unable to locate provider class: " + cname, e);
                }
            }
        }
    }

    private void init_FilterInitParameters() {
        this.configurationManager.addContainerProvider(new ConfigurationProvider(){

            @Override
            public void destroy() {
            }

            @Override
            public void init(Configuration configuration) throws ConfigurationException {
            }

            @Override
            public void loadPackages() throws ConfigurationException {
            }

            @Override
            public boolean needsReload() {
                return false;
            }

            @Override
            public void register(ContainerBuilder builder, LocatableProperties props) throws ConfigurationException {
                props.putAll(Dispatcher.this.initParams);
            }
        });
    }

    private void init_AliasStandardObjects() {
        this.configurationManager.addContainerProvider(new DefaultBeanSelectionProvider());
    }

    private Container init_PreloadConfiguration() {
        Container container = this.getContainer();
        boolean reloadi18n = Boolean.valueOf(container.getInstance(String.class, "struts.i18n.reload"));
        LocalizedTextUtil.setReloadBundles(reloadi18n);
        boolean devMode = Boolean.valueOf(container.getInstance(String.class, "struts.devMode"));
        LocalizedTextUtil.setDevMode(devMode);
        return container;
    }

    private void init_CheckWebLogicWorkaround(Container container) {
        if (this.servletContext != null && StringUtils.contains((CharSequence)this.servletContext.getServerInfo(), (CharSequence)"WebLogic")) {
            LOG.info("WebLogic server detected. Enabling Struts parameter access work-around.");
            this.paramsWorkaroundEnabled = true;
        } else {
            this.paramsWorkaroundEnabled = "true".equals(container.getInstance(String.class, "struts.dispatcher.parametersWorkaround"));
        }
    }

    public void init() {
        if (this.configurationManager == null) {
            this.configurationManager = this.createConfigurationManager("struts");
        }
        try {
            this.init_FileManager();
            this.init_DefaultProperties();
            this.init_TraditionalXmlConfigurations();
            this.init_LegacyStrutsProperties();
            this.init_CustomConfigurationProviders();
            this.init_FilterInitParameters();
            this.init_AliasStandardObjects();
            Container container = this.init_PreloadConfiguration();
            container.inject(this);
            this.init_CheckWebLogicWorkaround(container);
            if (!dispatcherListeners.isEmpty()) {
                for (DispatcherListener l : dispatcherListeners) {
                    l.dispatcherInitialized(this);
                }
            }
            this.errorHandler.init(this.servletContext);
        }
        catch (Exception ex) {
            LOG.error("Dispatcher initialization failed", (Throwable)ex);
            throw new StrutsException(ex);
        }
    }

    protected ConfigurationManager createConfigurationManager(String name) {
        return new ConfigurationManager(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAction(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws ServletException {
        block13: {
            ActionContext ctx;
            boolean nullStack;
            Map<String, Object> extraContext = this.createContextMap(request, response, mapping);
            ValueStack stack = (ValueStack)request.getAttribute("struts.valueStack");
            boolean bl = nullStack = stack == null;
            if (nullStack && (ctx = ActionContext.getContext()) != null) {
                stack = ctx.getValueStack();
            }
            if (stack != null) {
                extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", this.valueStackFactory.createValueStack(stack));
            }
            String timerKey = "Handling request from Dispatcher";
            try {
                UtilTimerStack.push(timerKey);
                String namespace = mapping.getNamespace();
                String name = mapping.getName();
                String method = mapping.getMethod();
                ActionProxy proxy = this.getContainer().getInstance(ActionProxyFactory.class).createActionProxy(namespace, name, method, extraContext, true, false);
                request.setAttribute("struts.valueStack", (Object)proxy.getInvocation().getStack());
                if (mapping.getResult() != null) {
                    Result result = mapping.getResult();
                    result.execute(proxy.getInvocation());
                } else {
                    proxy.execute();
                }
                if (!nullStack) {
                    request.setAttribute("struts.valueStack", (Object)stack);
                }
            }
            catch (ConfigurationException e) {
                this.logConfigurationException(request, e);
                this.sendError(request, response, 404, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.handleException || this.devMode) {
                    this.sendError(request, response, 500, e);
                    break block13;
                }
                throw new ServletException((Throwable)e);
            }
            finally {
                UtilTimerStack.pop(timerKey);
            }
        }
    }

    protected void logConfigurationException(HttpServletRequest request, ConfigurationException e) {
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = uri + "?" + request.getQueryString();
        }
        if (this.devMode) {
            LOG.error("Could not find action or result: {}", (Object)uri, (Object)e);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Could not find action or result: {}", (Object)uri, (Object)e);
        }
    }

    public Map<String, Object> createContextMap(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        RequestMap requestMap = new RequestMap(request);
        HttpParameters params = HttpParameters.create(request.getParameterMap()).build();
        SessionMap session = new SessionMap(request);
        ApplicationMap application = new ApplicationMap(this.servletContext);
        HashMap<String, Object> extraContext = this.createContextMap(requestMap, params, session, application, request, response);
        if (mapping != null) {
            extraContext.put("struts.actionMapping", mapping);
        }
        return extraContext;
    }

    public HashMap<String, Object> createContextMap(Map requestMap, HttpParameters parameters, Map sessionMap, Map applicationMap, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork2.ActionContext.parameters", parameters);
        extraContext.put("com.opensymphony.xwork2.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork2.ActionContext.application", applicationMap);
        Locale locale = this.defaultLocale != null ? LocalizedTextUtil.localeFromString(this.defaultLocale, request.getLocale()) : request.getLocale();
        extraContext.put("com.opensymphony.xwork2.ActionContext.locale", locale);
        extraContext.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", request);
        extraContext.put("com.opensymphony.xwork2.dispatcher.HttpServletResponse", response);
        extraContext.put("com.opensymphony.xwork2.dispatcher.ServletContext", this.servletContext);
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameters);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    protected String getSaveDir() {
        String saveDir = this.multipartSaveDir.trim();
        if (saveDir.equals("")) {
            File tempdir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
            LOG.info("Unable to find 'struts.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
            if (tempdir != null) {
                saveDir = tempdir.toString();
                this.setMultipartSaveDir(saveDir);
            }
        } else {
            File multipartSaveDir = new File(saveDir);
            if (!multipartSaveDir.exists() && !multipartSaveDir.mkdirs()) {
                String logMessage;
                try {
                    logMessage = "Could not find create multipart save directory '" + multipartSaveDir.getCanonicalPath() + "'.";
                }
                catch (IOException e) {
                    logMessage = "Could not find create multipart save directory '" + multipartSaveDir.toString() + "'.";
                }
                if (this.devMode) {
                    LOG.error(logMessage);
                } else {
                    LOG.warn(logMessage);
                }
            }
        }
        LOG.debug("saveDir={}", (Object)saveDir);
        return saveDir;
    }

    public void prepare(HttpServletRequest request, HttpServletResponse response) {
        String encoding = null;
        if (this.defaultEncoding != null) {
            encoding = this.defaultEncoding;
        }
        if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
            encoding = "UTF-8";
        }
        Locale locale = null;
        if (this.defaultLocale != null) {
            locale = LocalizedTextUtil.localeFromString(this.defaultLocale, request.getLocale());
        }
        if (encoding != null) {
            this.applyEncoding(request, encoding);
        }
        if (locale != null) {
            response.setLocale(locale);
        }
        if (this.paramsWorkaroundEnabled) {
            request.getParameter("foo");
        }
    }

    private void applyEncoding(HttpServletRequest request, String encoding) {
        try {
            if (!encoding.equals(request.getCharacterEncoding())) {
                request.setCharacterEncoding(encoding);
            }
        }
        catch (Exception e) {
            LOG.error("Error setting character encoding to '{}' - ignoring.", (Object)encoding, (Object)e);
        }
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request) throws IOException {
        if (request instanceof StrutsRequestWrapper) {
            return request;
        }
        String content_type = request.getContentType();
        if (content_type != null && content_type.contains("multipart/form-data")) {
            MultiPartRequest mpr = this.getMultiPartRequest();
            LocaleProvider provider = this.getContainer().getInstance(LocaleProvider.class);
            request = new MultiPartRequestWrapper(mpr, (HttpServletRequest)request, this.getSaveDir(), provider, this.disableRequestAttributeValueStackLookup);
        } else {
            request = new StrutsRequestWrapper((HttpServletRequest)request, this.disableRequestAttributeValueStackLookup);
        }
        return request;
    }

    protected MultiPartRequest getMultiPartRequest() {
        MultiPartRequest mpr = null;
        Set<String> multiNames = this.getContainer().getInstanceNames(MultiPartRequest.class);
        for (String multiName : multiNames) {
            if (!multiName.equals(this.multipartHandlerName)) continue;
            mpr = this.getContainer().getInstance(MultiPartRequest.class, multiName);
        }
        if (mpr == null) {
            mpr = this.getContainer().getInstance(MultiPartRequest.class);
        }
        return mpr;
    }

    public void cleanUpRequest(HttpServletRequest request) {
        ContainerHolder.clear();
        if (!(request instanceof MultiPartRequestWrapper)) {
            return;
        }
        MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper)request;
        multiWrapper.cleanUp();
    }

    public void sendError(HttpServletRequest request, HttpServletResponse response, int code, Exception e) {
        this.errorHandler.handleError(request, response, code, e);
    }

    public void cleanUpAfterInit() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning up resources used to init Dispatcher");
        }
        ContainerHolder.clear();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Container getContainer() {
        if (ContainerHolder.get() != null) {
            return ContainerHolder.get();
        }
        ConfigurationManager mgr = this.getConfigurationManager();
        if (mgr == null) {
            throw new IllegalStateException("The configuration manager shouldn't be null");
        }
        Configuration config = mgr.getConfiguration();
        if (config == null) {
            throw new IllegalStateException("Unable to load configuration");
        }
        Container container = config.getContainer();
        ContainerHolder.store(container);
        return container;
    }

    public static class Locator {
        public Location getLocation(Object obj) {
            Location loc = LocationUtils.getLocation(obj);
            if (loc == null) {
                return Location.UNKNOWN;
            }
            return loc;
        }
    }
}

