/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateEngine;
import org.apache.struts2.xwork2.util.ClassLoaderUtil;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;

public abstract class BaseTemplateEngine
implements TemplateEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTemplateEngine.class);
    public static final String DEFAULT_THEME_PROPERTIES_FILE_NAME = "theme.properties";
    final Map<String, Properties> themeProps = new HashMap<String, Properties>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getThemeProps(Template template) {
        Map<String, Properties> map = this.themeProps;
        synchronized (map) {
            Properties props = this.themeProps.get(template.getTheme());
            if (props == null) {
                props = this.readNewProperties(template);
                this.themeProps.put(template.getTheme(), props);
            }
            return props;
        }
    }

    private Properties readNewProperties(Template template) {
        String propName = this.buildPropertyFilename(template);
        return this.loadProperties(propName);
    }

    private Properties loadProperties(String propName) {
        InputStream is = this.readProperty(propName);
        Properties props = new Properties();
        if (is != null) {
            this.tryToLoadPropertiesFromStream(props, propName, is);
        }
        return props;
    }

    private InputStream readProperty(String propName) {
        InputStream is = this.tryReadingPropertyFileFromFileSystem(propName);
        if (is == null) {
            is = this.readPropertyFromClasspath(propName);
        }
        return is;
    }

    private InputStream readPropertyFromClasspath(String propName) {
        return ClassLoaderUtil.getResourceAsStream((String)propName, this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToLoadPropertiesFromStream(Properties props, String propName, InputStream is) {
        try {
            props.load(is);
        }
        catch (IOException e) {
            LOG.error("Could not load " + propName, (Throwable)e, new String[0]);
        }
        finally {
            this.tryCloseStream(is);
        }
    }

    private void tryCloseStream(InputStream is) {
        block2: {
            try {
                is.close();
            }
            catch (IOException io) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Unable to close input stream", (Throwable)io, new String[0]);
            }
        }
    }

    private String buildPropertyFilename(Template template) {
        return template.getDir() + "/" + template.getTheme() + "/" + this.getThemePropertiesFileName();
    }

    private InputStream tryReadingPropertyFileFromFileSystem(String propName) {
        File propFile = new File(propName);
        try {
            return this.createFileInputStream(propFile);
        }
        catch (FileNotFoundException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unable to find file in filesystem [" + propFile.getAbsolutePath() + "]", new String[0]);
            }
            return null;
        }
    }

    private InputStream createFileInputStream(File propFile) throws FileNotFoundException {
        FileInputStream is = null;
        if (propFile.exists()) {
            is = new FileInputStream(propFile);
        }
        return is;
    }

    protected String getFinalTemplateName(Template template) {
        String t = template.toString();
        if (t.indexOf(".") <= 0) {
            return t + "." + this.getSuffix();
        }
        return t;
    }

    protected String getThemePropertiesFileName() {
        return DEFAULT_THEME_PROPERTIES_FILE_NAME;
    }

    protected abstract String getSuffix();
}

