/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.xwork2.ActionContext;
import org.apache.struts2.xwork2.ActionInvocation;
import org.apache.struts2.xwork2.ActionProxy;
import org.apache.struts2.xwork2.ValidationAware;
import org.apache.struts2.xwork2.inject.Inject;
import org.apache.struts2.xwork2.interceptor.AbstractInterceptor;
import org.apache.struts2.xwork2.util.LocalizedTextUtil;
import org.apache.struts2.xwork2.util.PatternMatcher;
import org.apache.struts2.xwork2.util.TextParseUtil;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -4764627478894962478L;
    protected static final Logger LOG = LoggerFactory.getLogger(FileUploadInterceptor.class);
    private static final String DEFAULT_MESSAGE = "no.message.found";
    protected boolean useActionMessageBundle;
    protected Long maximumSize;
    protected Set<String> allowedTypesSet = Collections.emptySet();
    protected Set<String> allowedExtensionsSet = Collections.emptySet();
    private PatternMatcher matcher;

    @Inject
    public void setMatcher(PatternMatcher matcher) {
        this.matcher = matcher;
    }

    public void setUseActionMessageBundle(String value) {
        this.useActionMessageBundle = Boolean.valueOf(value);
    }

    public void setAllowedExtensions(String allowedExtensions) {
        this.allowedExtensionsSet = TextParseUtil.commaDelimitedStringToSet((String)allowedExtensions);
    }

    public void setAllowedTypes(String allowedTypes) {
        this.allowedTypesSet = TextParseUtil.commaDelimitedStringToSet((String)allowedTypes);
    }

    public void setMaximumSize(Long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        MultiPartRequestWrapper multiWrapper;
        ActionContext ac = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ac.get("org.apache.struts2.xwork2.dispatcher.HttpServletRequest");
        if (!(request instanceof MultiPartRequestWrapper)) {
            if (LOG.isDebugEnabled()) {
                ActionProxy proxy = invocation.getProxy();
                LOG.debug(this.getTextMessage("struts.messages.bypass.request", new Object[]{proxy.getNamespace(), proxy.getActionName()}, ac.getLocale()), new String[0]);
            }
            return invocation.invoke();
        }
        ValidationAware validation = null;
        Object action = invocation.getAction();
        if (action instanceof ValidationAware) {
            validation = (ValidationAware)action;
        }
        if ((multiWrapper = (MultiPartRequestWrapper)request).hasErrors()) {
            for (String error : multiWrapper.getErrors()) {
                if (validation != null) {
                    validation.addActionError(error);
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(error, new String[0]);
            }
        }
        Enumeration<String> fileParameterNames = multiWrapper.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            String inputName = fileParameterNames.nextElement();
            Object[] contentType = multiWrapper.getContentTypes(inputName);
            if (this.isNonEmpty(contentType)) {
                Object[] fileName = multiWrapper.getFileNames(inputName);
                if (this.isNonEmpty(fileName)) {
                    File[] files = multiWrapper.getFiles(inputName);
                    if (files == null || files.length <= 0) continue;
                    ArrayList<File> acceptedFiles = new ArrayList<File>(files.length);
                    ArrayList<Object> acceptedContentTypes = new ArrayList<Object>(files.length);
                    ArrayList<Object> acceptedFileNames = new ArrayList<Object>(files.length);
                    String contentTypeName = inputName + "ContentType";
                    String fileNameName = inputName + "FileName";
                    for (int index = 0; index < files.length; ++index) {
                        if (!this.acceptFile(action, files[index], (String)fileName[index], (String)contentType[index], inputName, validation, ac.getLocale())) continue;
                        acceptedFiles.add(files[index]);
                        acceptedContentTypes.add(contentType[index]);
                        acceptedFileNames.add(fileName[index]);
                    }
                    if (acceptedFiles.isEmpty()) continue;
                    Map params = ac.getParameters();
                    params.put(inputName, acceptedFiles.toArray(new File[acceptedFiles.size()]));
                    params.put(contentTypeName, acceptedContentTypes.toArray(new String[acceptedContentTypes.size()]));
                    params.put(fileNameName, acceptedFileNames.toArray(new String[acceptedFileNames.size()]));
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(this.getTextMessage(action, "struts.messages.invalid.file", new Object[]{inputName}, ac.getLocale()), new String[0]);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn(this.getTextMessage(action, "struts.messages.invalid.content.type", new Object[]{inputName}, ac.getLocale()), new String[0]);
        }
        return invocation.invoke();
    }

    protected boolean acceptFile(Object action, File file, String filename, String contentType, String inputName, ValidationAware validation, Locale locale) {
        boolean fileIsAcceptable = false;
        if (file == null) {
            String errMsg = this.getTextMessage(action, "struts.messages.error.uploading", new Object[]{inputName}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(errMsg, new String[0]);
            }
        } else if (this.maximumSize != null && this.maximumSize < file.length()) {
            String errMsg = this.getTextMessage(action, "struts.messages.error.file.too.large", new Object[]{inputName, filename, file.getName(), "" + file.length()}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(errMsg, new String[0]);
            }
        } else if (!this.allowedTypesSet.isEmpty() && !this.containsItem(this.allowedTypesSet, contentType)) {
            String errMsg = this.getTextMessage(action, "struts.messages.error.content.type.not.allowed", new Object[]{inputName, filename, file.getName(), contentType}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(errMsg, new String[0]);
            }
        } else if (!this.allowedExtensionsSet.isEmpty() && !this.hasAllowedExtension(this.allowedExtensionsSet, filename)) {
            String errMsg = this.getTextMessage(action, "struts.messages.error.file.extension.not.allowed", new Object[]{inputName, filename, file.getName(), contentType}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(errMsg, new String[0]);
            }
        } else {
            fileIsAcceptable = true;
        }
        return fileIsAcceptable;
    }

    private boolean hasAllowedExtension(Collection<String> extensionCollection, String filename) {
        if (filename == null) {
            return false;
        }
        String lowercaseFilename = filename.toLowerCase();
        for (String extension : extensionCollection) {
            if (!lowercaseFilename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItem(Collection<String> itemCollection, String item) {
        for (String pattern : itemCollection) {
            if (!this.matchesWildcard(pattern, item)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesWildcard(String pattern, String text) {
        Object o = this.matcher.compilePattern(pattern);
        return this.matcher.match(new HashMap(), text, o);
    }

    private boolean isNonEmpty(Object[] objArray) {
        boolean result = false;
        for (int index = 0; index < objArray.length && !result; ++index) {
            if (objArray[index] == null) continue;
            result = true;
        }
        return result;
    }

    private String getTextMessage(String messageKey, Object[] args, Locale locale) {
        return this.getTextMessage(null, messageKey, args, locale);
    }

    private String getTextMessage(Object action, String messageKey, Object[] args, Locale locale) {
        if (args == null || args.length == 0) {
            if (action != null && this.useActionMessageBundle) {
                return LocalizedTextUtil.findText(action.getClass(), (String)messageKey, (Locale)locale);
            }
            return LocalizedTextUtil.findText(((Object)((Object)this)).getClass(), (String)messageKey, (Locale)locale);
        }
        if (action != null && this.useActionMessageBundle) {
            return LocalizedTextUtil.findText(action.getClass(), (String)messageKey, (Locale)locale, (String)DEFAULT_MESSAGE, (Object[])args);
        }
        return LocalizedTextUtil.findText(((Object)((Object)this)).getClass(), (String)messageKey, (Locale)locale, (String)DEFAULT_MESSAGE, (Object[])args);
    }
}

