/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.validation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.apache.struts2.xwork2.ActionInvocation;
import org.apache.struts2.xwork2.util.AnnotationUtils;
import org.apache.struts2.xwork2.validator.ValidationInterceptor;

public class AnnotationValidationInterceptor
extends ValidationInterceptor {
    private static final long serialVersionUID = 1813272797367431184L;

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action != null) {
            Method method = this.getActionMethod(action.getClass(), invocation.getProxy().getMethod());
            Collection annotatedMethods = AnnotationUtils.getAnnotatedMethods(action.getClass(), (Class[])new Class[]{SkipValidation.class});
            if (annotatedMethods.contains(method)) {
                return invocation.invoke();
            }
            for (Class<?> clazz = action.getClass().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                annotatedMethods = AnnotationUtils.getAnnotatedMethods(clazz, (Class[])new Class[]{SkipValidation.class});
                if (annotatedMethods == null) continue;
                for (Method annotatedMethod : annotatedMethods) {
                    if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypes(), method.getParameterTypes()) || !Arrays.equals(annotatedMethod.getExceptionTypes(), method.getExceptionTypes())) continue;
                    return invocation.invoke();
                }
            }
        }
        return super.doIntercept(invocation);
    }

    protected Method getActionMethod(Class actionClass, String methodName) throws NoSuchMethodException {
        Method method;
        try {
            method = actionClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                String altMethodName = "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                method = actionClass.getMethod(altMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
        return method;
    }
}

