/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.aspects.statistics.mbean.StatisticsViewMBean;
import org.apache.synapse.aspects.statistics.view.InOutStatisticsView;
import org.apache.synapse.aspects.statistics.view.StatisticsViewStrategy;
import org.apache.synapse.aspects.statistics.view.SystemViewStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsView
implements StatisticsViewMBean {
    private final StatisticsCollector collector;
    private final StatisticsViewStrategy systemViewStrategy = new SystemViewStrategy();

    public StatisticsView(StatisticsCollector collector) {
        this.collector = collector;
    }

    @Override
    public List<String> getSystemEndpointStats(String id) {
        return this.getAsList(this.systemViewStrategy.determineView(id, this.collector.getStatisticsRecords(), ComponentType.ENDPOINT));
    }

    @Override
    public List<String> getSystemSequenceStats(String id) {
        return this.getAsList(this.systemViewStrategy.determineView(id, this.collector.getStatisticsRecords(), ComponentType.SEQUENCE));
    }

    @Override
    public List<String> getSystemProxyServiceStats(String id) {
        return this.getAsList(this.systemViewStrategy.determineView(id, this.collector.getStatisticsRecords(), ComponentType.PROXYSERVICE));
    }

    @Override
    public List<String> getSystemEndpointsStats() {
        return this.getAllStatsAsList(this.systemViewStrategy.determineView(this.collector.getStatisticsRecords(), ComponentType.ENDPOINT));
    }

    @Override
    public List<String> getSystemSequencesStats() {
        return this.getAllStatsAsList(this.systemViewStrategy.determineView(this.collector.getStatisticsRecords(), ComponentType.SEQUENCE));
    }

    @Override
    public List<String> getSystemProxyServicesStats() {
        return this.getAllStatsAsList(this.systemViewStrategy.determineView(this.collector.getStatisticsRecords(), ComponentType.PROXYSERVICE));
    }

    @Override
    public void clearAllStatistics() {
        this.collector.clearStatistics();
    }

    private List<String> getAsList(Map<String, InOutStatisticsView> viewMap) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (InOutStatisticsView view : viewMap.values()) {
            if (view == null) continue;
            returnList.add(view.toString());
        }
        return returnList;
    }

    private List<String> getAllStatsAsList(Map<String, Map<String, InOutStatisticsView>> statsMap) {
        ArrayList<String> tobeReturn = new ArrayList<String>();
        for (Map<String, InOutStatisticsView> viewMap : statsMap.values()) {
            tobeReturn.addAll(this.getAsList(viewMap));
        }
        return tobeReturn;
    }
}

