/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.ext.AnnotatedCommandMediator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class AnnotatedCommandMediatorFactory
extends AbstractMediatorFactory {
    private static final QName ANNOTATED_COMMAND_Q = new QName("http://ws.apache.org/ns/synapse", "annotatedCommand");

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        AnnotatedCommandMediator pojoMediator = new AnnotatedCommandMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        if (name == null) {
            String msg = "The name of the actual POJO command implementation class is a required attribute";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            pojoMediator.setCommand(this.getClass().getClassLoader().loadClass(name.getAttributeValue()));
        }
        catch (ClassNotFoundException e) {
            this.handleException("Unable to load the class specified as the command " + name.getAttributeValue(), e);
        }
        Iterator it = elem.getChildElements();
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            if (!"property".equals(child.getLocalName())) continue;
            String propName = child.getAttribute(ATT_NAME).getAttributeValue();
            if (propName == null) {
                this.handleException("A POJO command mediator property must specify the name attribute");
                continue;
            }
            if (child.getAttribute(ATT_EXPRN) != null) {
                try {
                    SynapseXPath xpath = SynapseXPathFactory.getSynapseXPath(child, ATT_EXPRN);
                    pojoMediator.addMessageSetterProperty(propName, xpath);
                }
                catch (JaxenException e) {
                    this.handleException("Error instantiating XPath expression : " + child.getAttribute(ATT_EXPRN), (Exception)((Object)e));
                }
                continue;
            }
            if (child.getAttribute(ATT_VALUE) != null) {
                pojoMediator.addStaticSetterProperty(propName, child.getAttribute(ATT_VALUE).getAttributeValue());
                continue;
            }
            this.handleException("A POJO mediator property must specify either name and expression attributes, or name and value attributes");
        }
        return pojoMediator;
    }

    public QName getTagQName() {
        return ANNOTATED_COMMAND_Q;
    }
}

