/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.TargetSerializer;
import org.apache.synapse.mediators.filters.router.ConditionalRoute;
import org.apache.synapse.mediators.filters.router.ConditionalRouterMediator;

public class ConditionalRouterMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        OMElement conditionalRouterElem = fac.createOMElement("conditionalRouter", synNS);
        ConditionalRouterMediatorSerializer.saveTracingState(conditionalRouterElem, m);
        ConditionalRouterMediator conditionalRouterMediator = (ConditionalRouterMediator)m;
        if (conditionalRouterMediator.isContinueAfterExplicitlySet()) {
            conditionalRouterElem.addAttribute("continueAfter", Boolean.toString(conditionalRouterMediator.isContinueAfter()), nullNS);
        }
        for (ConditionalRoute conditionalRoute : conditionalRouterMediator.getConditionalRoutes()) {
            EvaluatorSerializer evaluatorSerializer;
            OMElement routeElem = fac.createOMElement("conditionalRoute", synNS);
            if (conditionalRoute.isBreakRouteExplicitlySet()) {
                routeElem.addAttribute("breakRoute", Boolean.toString(conditionalRoute.isBreakRoute()), nullNS);
            }
            if (conditionalRoute.getEvaluator() != null && (evaluatorSerializer = EvaluatorSerializerFinder.getInstance().getSerializer(conditionalRoute.getEvaluator().getName())) != null) {
                OMElement conditionElement = fac.createOMElement("condition", synNS);
                try {
                    evaluatorSerializer.serialize(conditionElement, conditionalRoute.getEvaluator());
                }
                catch (EvaluatorException e) {
                    this.handleException("Cannot serialize the Evaluator", (Exception)((Object)e));
                }
                routeElem.addChild((OMNode)conditionElement);
            }
            if (conditionalRoute.getTarget() != null) {
                routeElem.addChild((OMNode)TargetSerializer.serializeTarget(conditionalRoute.getTarget()));
            } else {
                this.handleException("ConditionalRoute in a conditional router has to have a target");
            }
            if (conditionalRoute.getTarget().isAsynchronous()) {
                routeElem.addAttribute(fac.createOMAttribute("asynchronous", nullNS, "true"));
            }
            conditionalRouterElem.addChild((OMNode)routeElem);
        }
        return conditionalRouterElem;
    }

    public String getMediatorClassName() {
        return ConditionalRouterMediator.class.getName();
    }
}

