/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.builtin.RMSequenceMediator;

public class RMSequenceMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof RMSequenceMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        RMSequenceMediator mediator = (RMSequenceMediator)m;
        OMElement sequence = fac.createOMElement("RMSequence", synNS);
        RMSequenceMediatorSerializer.saveTracingState(sequence, mediator);
        if (mediator.isSingle() && mediator.getCorrelation() != null) {
            this.handleException("Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a correlation attribute specified.");
        }
        if (mediator.isSingle() && mediator.getLastMessage() != null) {
            this.handleException("Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a last-message attribute specified.");
        }
        if (mediator.isSingle()) {
            sequence.addAttribute(fac.createOMAttribute("single", nullNS, String.valueOf(mediator.isSingle())));
        } else if (mediator.getCorrelation() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getCorrelation(), sequence, "correlation");
        } else {
            this.handleException("Invalid RMSequence mediator. Specify a single message sequence or a correlation attribute.");
        }
        if (mediator.getLastMessage() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getLastMessage(), sequence, "last-message");
        }
        if (mediator.getVersion() != null) {
            sequence.addAttribute(fac.createOMAttribute("version", nullNS, mediator.getVersion()));
        }
        return sequence;
    }

    public String getMediatorClassName() {
        return RMSequenceMediator.class.getName();
    }
}

