/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.config.xml.ResourceMapSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.builtin.ValidateMediator;

public class ValidateMediatorSerializer
extends AbstractListMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof ValidateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        ValidateMediator mediator = (ValidateMediator)m;
        OMElement validate = fac.createOMElement("validate", synNS);
        ValidateMediatorSerializer.saveTracingState(validate, mediator);
        if (mediator.getSource() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getSource(), validate, "source");
        }
        for (Value key : mediator.getSchemaKeys()) {
            OMElement schema = fac.createOMElement("schema", synNS, (OMContainer)validate);
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(key, "key", schema);
        }
        ResourceMapSerializer.serializeResourceMap(validate, mediator.getResourceMap());
        List<MediatorProperty> features = mediator.getFeatures();
        if (!features.isEmpty()) {
            for (MediatorProperty mp : features) {
                OMElement feature = fac.createOMElement("feature", synNS, (OMContainer)validate);
                if (mp.getName() != null) {
                    feature.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
                } else {
                    this.handleException("The Feature name is missing");
                }
                if (mp.getValue() != null) {
                    feature.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                    continue;
                }
                this.handleException("The Feature value is missing");
            }
        }
        OMElement onFail = fac.createOMElement("on-fail", synNS, (OMContainer)validate);
        this.serializeChildren(onFail, mediator.getList());
        return validate;
    }

    public String getMediatorClassName() {
        return ValidateMediator.class.getName();
    }
}

