/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class DynamicLoadbalanceEndpointFactory
extends EndpointFactory {
    private static final Log log = LogFactory.getLog(DynamicLoadbalanceEndpointFactory.class);
    private static DynamicLoadbalanceEndpointFactory instance = new DynamicLoadbalanceEndpointFactory();

    private DynamicLoadbalanceEndpointFactory() {
    }

    public static DynamicLoadbalanceEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement loadbalanceElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "dynamicLoadbalance"));
        if (loadbalanceElement != null) {
            String failover;
            OMElement sessionElement;
            DynamicLoadbalanceEndpoint loadbalanceEndpoint = new DynamicLoadbalanceEndpoint();
            OMAttribute name = epConfig.getAttribute(new QName("", "name"));
            if (name != null) {
                loadbalanceEndpoint.setName(name.getAttributeValue());
            }
            if ((sessionElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"))) != null) {
                String type;
                OMElement sessionTimeout = sessionElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sessionTimeout"));
                if (sessionTimeout != null) {
                    try {
                        loadbalanceEndpoint.setSessionTimeout(Long.parseLong(sessionTimeout.getText().trim()));
                    }
                    catch (NumberFormatException nfe) {
                        DynamicLoadbalanceEndpointFactory.handleException("Invalid session timeout value : " + sessionTimeout.getText());
                    }
                }
                if ((type = sessionElement.getAttributeValue(new QName("type"))).equalsIgnoreCase("soap")) {
                    SoapSessionDispatcher soapDispatcher = new SoapSessionDispatcher();
                    loadbalanceEndpoint.setDispatcher(soapDispatcher);
                } else if (type.equalsIgnoreCase("http")) {
                    HttpSessionDispatcher httpDispatcher = new HttpSessionDispatcher();
                    loadbalanceEndpoint.setDispatcher(httpDispatcher);
                }
                loadbalanceEndpoint.setSessionAffinity(true);
            }
            if ((failover = loadbalanceElement.getAttributeValue(new QName("failover"))) != null && failover.equalsIgnoreCase("false")) {
                loadbalanceEndpoint.setFailover(false);
            } else {
                loadbalanceEndpoint.setFailover(true);
            }
            OMElement eventHandler = loadbalanceElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "membershipHandler"));
            if (eventHandler != null) {
                String clazz = eventHandler.getAttributeValue(new QName("", "class")).trim();
                try {
                    LoadBalanceMembershipHandler lbMembershipHandler = (LoadBalanceMembershipHandler)Class.forName(clazz).newInstance();
                    Properties lbProperties = new Properties();
                    Iterator props = eventHandler.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "property"));
                    while (props.hasNext()) {
                        OMElement prop = (OMElement)props.next();
                        String propName = prop.getAttributeValue(new QName("", "name")).trim();
                        String propValue = prop.getAttributeValue(new QName("", "value")).trim();
                        lbProperties.put(propName, propValue);
                    }
                    LoadbalanceAlgorithm algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, null);
                    lbMembershipHandler.init(lbProperties, algorithm);
                    loadbalanceEndpoint.setLoadBalanceMembershipHandler(lbMembershipHandler);
                }
                catch (Exception e) {
                    String msg = "Could not instantiate LoadBalanceMembershipHandler implementation " + clazz;
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException(msg, e);
                }
            }
            this.processProperties(loadbalanceEndpoint, epConfig);
            return loadbalanceEndpoint;
        }
        return null;
    }
}

