/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.AddressEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.DynamicLoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointFactory;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointFactory;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.RecipientListEndpointFactory;
import org.apache.synapse.config.xml.endpoints.ResolvingEndpointFactory;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.TemplateEndpointFactory;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointFactory;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.mediators.MediatorProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointFactory
implements XMLToObjectMapper {
    static Log log;
    private DefinitionFactory customDefnFactory = null;
    private static final String ENDPOINT_NAME_PREFIX = "endpoint_";
    public static final QName ON_FAULT_Q;
    private static final QName DESCRIPTION_Q;

    protected EndpointFactory() {
        log = LogFactory.getLog(this.getClass());
    }

    public static Endpoint getEndpointFromElement(OMElement elem, boolean isAnonymous, Properties properties) {
        return EndpointFactory.getEndpointFactory(elem).createEndpointWithName(elem, isAnonymous, properties);
    }

    public static Endpoint getEndpointFromElement(OMElement elem, DefinitionFactory factory, boolean isAnonymous, Properties properties) {
        EndpointFactory fac = EndpointFactory.getEndpointFactory(elem);
        fac.setEndpointDefinitionFactory(factory);
        return fac.createEndpointWithName(elem, isAnonymous, properties);
    }

    @Override
    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            return this.createEndpointWithName((OMElement)om, false, properties);
        }
        EndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    protected abstract Endpoint createEndpoint(OMElement var1, boolean var2, Properties var3);

    private Endpoint createEndpointWithName(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMAttribute onFaultAtt;
        Endpoint ep = this.createEndpoint(epConfig, anonymousEndpoint, properties);
        OMElement descriptionElem = epConfig.getFirstChildWithName(DESCRIPTION_Q);
        if (descriptionElem != null) {
            ep.setDescription(descriptionElem.getText());
        }
        if (anonymousEndpoint && ep.getName() == null) {
            String uuid = UIDGenerator.generateUID();
            uuid = uuid.replace(':', '_');
            ep.setName(ENDPOINT_NAME_PREFIX + uuid);
            if (ep instanceof AbstractEndpoint) {
                ((AbstractEndpoint)ep).setAnonymous(true);
            }
        }
        if ((onFaultAtt = epConfig.getAttribute(ON_FAULT_Q)) != null) {
            ep.setErrorHandler(onFaultAtt.getAttributeValue());
        }
        return ep;
    }

    protected void extractSpecificEndpointProperties(EndpointDefinition definition, OMElement elem) {
    }

    private static EndpointFactory getEndpointFactory(OMElement configElement) {
        if (configElement.getAttribute(new QName("key")) != null) {
            return IndirectEndpointFactory.getInstance();
        }
        if (configElement.getAttribute(new QName("key-expression")) != null) {
            return ResolvingEndpointFactory.getInstance();
        }
        if (configElement.getAttribute(new QName("template")) != null) {
            return new TemplateEndpointFactory();
        }
        OMElement addressElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"));
        if (addressElement != null) {
            return AddressEndpointFactory.getInstance();
        }
        OMElement wsdlElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"));
        if (wsdlElement != null) {
            return WSDLEndpointFactory.getInstance();
        }
        OMElement defaultElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "default"));
        if (defaultElement != null) {
            return DefaultEndpointFactory.getInstance();
        }
        OMElement lbElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (lbElement != null) {
            OMElement sessionElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"));
            if (sessionElement != null) {
                return SALoadbalanceEndpointFactory.getInstance();
            }
            return LoadbalanceEndpointFactory.getInstance();
        }
        OMElement dlbElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "dynamicLoadbalance"));
        if (dlbElement != null) {
            return DynamicLoadbalanceEndpointFactory.getInstance();
        }
        OMElement foElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "failover"));
        if (foElement != null) {
            return FailoverEndpointFactory.getInstance();
        }
        OMElement rcplElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "recipientlist"));
        if (rcplElement != null) {
            return RecipientListEndpointFactory.getInstance();
        }
        EndpointFactory.handleException("Invalid endpoint configuration.");
        return null;
    }

    protected ArrayList<Endpoint> getEndpoints(OMElement listEndpointElement, Endpoint parent, Properties properties) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = listEndpointElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT);
        while (iter.hasNext()) {
            OMElement endptElem = (OMElement)iter.next();
            Endpoint endpoint = EndpointFactory.getEndpointFromElement(endptElem, true, properties);
            if (endpoint instanceof IndirectEndpoint) {
                String key = ((IndirectEndpoint)endpoint).getKey();
                if (!keys.contains(key)) {
                    keys.add(key);
                } else {
                    EndpointFactory.handleException("Same endpoint definition cannot be used with in the siblings");
                }
            }
            endpoint.setParentEndpoint(parent);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public void setEndpointDefinitionFactory(DefinitionFactory factory) {
        this.customDefnFactory = factory;
    }

    public DefinitionFactory getEndpointDefinitionFactory() {
        return this.customDefnFactory;
    }

    protected void processProperties(PropertyInclude endpoint, OMElement endpointElement) {
        List<MediatorProperty> properties = MediatorPropertyFactory.getMediatorProperties(endpointElement);
        if (properties != null && properties.size() > 0) {
            endpoint.addProperties(properties);
        }
    }

    protected static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    static {
        ON_FAULT_Q = new QName("", "onError");
        DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");
    }
}

