/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.rest;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.rest.ResourceFactory;
import org.apache.synapse.rest.API;
import org.apache.synapse.rest.Handler;

public class APIFactory {
    private static final Log log = LogFactory.getLog(APIFactory.class);

    public static API createAPI(OMElement apiElt) {
        OMElement handlersElt;
        OMAttribute portAtt;
        OMAttribute contextAtt;
        OMAttribute nameAtt = apiElt.getAttribute(new QName("name"));
        if (nameAtt == null || "".equals(nameAtt.getAttributeValue())) {
            APIFactory.handleException("Attribute 'name' is required for an API definition");
        }
        if ((contextAtt = apiElt.getAttribute(new QName("context"))) == null || "".equals(contextAtt.getAttributeValue())) {
            APIFactory.handleException("Attribute 'context' is required for an API definition");
        }
        API api = new API(nameAtt.getAttributeValue(), contextAtt.getAttributeValue());
        OMAttribute hostAtt = apiElt.getAttribute(new QName("hostname"));
        if (hostAtt != null && !"".equals(hostAtt.getAttributeValue())) {
            api.setHost(hostAtt.getAttributeValue());
        }
        if ((portAtt = apiElt.getAttribute(new QName("port"))) != null && !"".equals(portAtt.getAttributeValue())) {
            api.setPort(Integer.parseInt(portAtt.getAttributeValue()));
        }
        Iterator resources = apiElt.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "resource"));
        boolean noResources = true;
        while (resources.hasNext()) {
            OMElement resourceElt = (OMElement)resources.next();
            api.addResource(ResourceFactory.createResource(resourceElt));
            noResources = false;
        }
        if (noResources) {
            APIFactory.handleException("An API must contain at least one resource definition");
        }
        if ((handlersElt = apiElt.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "handlers"))) != null) {
            Iterator handlers = handlersElt.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "handler"));
            while (handlers.hasNext()) {
                OMElement handlerElt = (OMElement)handlers.next();
                APIFactory.defineHandler(api, handlerElt);
            }
        }
        return api;
    }

    private static void defineHandler(API api, OMElement handlerElt) {
        String handlerClass = handlerElt.getAttributeValue(new QName("class"));
        if (handlerClass == null || "".equals(handlerClass)) {
            APIFactory.handleException("A handler element must have a class attribute");
        }
        try {
            Class<?> clazz = APIFactory.class.getClassLoader().loadClass(handlerClass);
            Handler handler = (Handler)clazz.newInstance();
            api.addHandler(handler);
        }
        catch (Exception e) {
            APIFactory.handleException("Error initializing API handler: " + handlerClass, e);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

