/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.endpoints.Endpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDefinition
implements AspectConfigurable {
    private Endpoint leafEndpoint = null;
    private String address = null;
    private boolean reliableMessagingOn = false;
    private boolean addressingOn = false;
    private String addressingVersion = null;
    private boolean securityOn = false;
    private String wsRMPolicyKey = null;
    private String wsSecPolicyKey = null;
    private String inboundWsSecPolicyKey = null;
    private String outboundWsSecPolicyKey = null;
    private boolean useSeparateListener = false;
    private boolean forcePOX = false;
    private boolean forceGET = false;
    private boolean forceSOAP11 = false;
    private boolean forceSOAP12 = false;
    private boolean forceREST = false;
    private boolean useMTOM = false;
    private boolean useSwa = false;
    private String format = null;
    private String charSetEncoding;
    private boolean replicationDisabled = false;
    private long timeoutDuration = 0L;
    private int timeoutAction = 100;
    private long initialSuspendDuration = -1L;
    private float suspendProgressionFactor = 1.0f;
    private long suspendMaximumDuration = Long.MAX_VALUE;
    private final List<Integer> suspendErrorCodes = new ArrayList<Integer>();
    private int retriesOnTimeoutBeforeSuspend = 0;
    private int retryDurationOnTimeout = 0;
    private final List<Integer> timeoutErrorCodes = new ArrayList<Integer>();
    private AspectConfiguration aspectConfiguration;
    private int traceState = 2;
    private final List<Integer> retryDisabledErrorCodes = new ArrayList<Integer>();

    public String getAddress() {
        return this.address;
    }

    public String getAddress(MessageContext messageContext) {
        if (this.address == null) {
            return null;
        }
        boolean matches = false;
        int s = 0;
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        StringBuffer computedAddress = new StringBuffer();
        Matcher matcher = pattern.matcher(this.address);
        while (matcher.find()) {
            Object property = messageContext.getProperty(this.address.substring(matcher.start() + 2, matcher.end() - 1));
            if (property == null) continue;
            computedAddress.append(this.address.substring(s, matcher.start()));
            computedAddress.append(property.toString());
            s = matcher.end();
            matches = true;
        }
        if (!matches) {
            return this.address;
        }
        computedAddress.append(this.address.substring(s, this.address.length()));
        return computedAddress.toString();
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isReliableMessagingOn() {
        return this.reliableMessagingOn;
    }

    public void setReliableMessagingOn(boolean reliableMessagingOn) {
        this.reliableMessagingOn = reliableMessagingOn;
    }

    public boolean isAddressingOn() {
        return this.addressingOn;
    }

    public void setAddressingOn(boolean addressingOn) {
        this.addressingOn = addressingOn;
    }

    public String getAddressingVersion() {
        return this.addressingVersion;
    }

    public void setAddressingVersion(String addressingVersion) {
        this.addressingVersion = addressingVersion;
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public void setSecurityOn(boolean securityOn) {
        this.securityOn = securityOn;
    }

    public String getWsSecPolicyKey() {
        return this.wsSecPolicyKey;
    }

    public void setWsSecPolicyKey(String wsSecPolicyKey) {
        this.wsSecPolicyKey = wsSecPolicyKey;
    }

    public String getInboundWsSecPolicyKey() {
        return this.inboundWsSecPolicyKey;
    }

    public void setInboundWsSecPolicyKey(String inboundWsSecPolicyKey) {
        this.inboundWsSecPolicyKey = inboundWsSecPolicyKey;
    }

    public String getOutboundWsSecPolicyKey() {
        return this.outboundWsSecPolicyKey;
    }

    public void setOutboundWsSecPolicyKey(String outboundWsSecPolicyKey) {
        this.outboundWsSecPolicyKey = outboundWsSecPolicyKey;
    }

    public String getWsRMPolicyKey() {
        return this.wsRMPolicyKey;
    }

    public void setWsRMPolicyKey(String wsRMPolicyKey) {
        this.wsRMPolicyKey = wsRMPolicyKey;
    }

    public void setUseSeparateListener(boolean b) {
        this.useSeparateListener = b;
    }

    public boolean isUseSeparateListener() {
        return this.useSeparateListener;
    }

    public void setForcePOX(boolean forcePOX) {
        this.forcePOX = forcePOX;
    }

    public boolean isForcePOX() {
        return this.forcePOX;
    }

    public boolean isForceGET() {
        return this.forceGET;
    }

    public void setForceGET(boolean forceGET) {
        this.forceGET = forceGET;
    }

    public void setForceSOAP11(boolean forceSOAP11) {
        this.forceSOAP11 = forceSOAP11;
    }

    public boolean isForceSOAP11() {
        return this.forceSOAP11;
    }

    public void setForceSOAP12(boolean forceSOAP12) {
        this.forceSOAP12 = forceSOAP12;
    }

    public boolean isForceSOAP12() {
        return this.forceSOAP12;
    }

    public boolean isForceREST() {
        return this.forceREST;
    }

    public void setForceREST(boolean forceREST) {
        this.forceREST = forceREST;
    }

    public boolean isUseMTOM() {
        return this.useMTOM;
    }

    public void setUseMTOM(boolean useMTOM) {
        this.useMTOM = useMTOM;
    }

    public boolean isUseSwa() {
        return this.useSwa;
    }

    public void setUseSwa(boolean useSwa) {
        this.useSwa = useSwa;
    }

    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public void setTimeoutDuration(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
    }

    public int getTimeoutAction() {
        return this.timeoutAction;
    }

    public void setTimeoutAction(int timeoutAction) {
        this.timeoutAction = timeoutAction;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCharSetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.charSetEncoding = charSetEncoding;
    }

    public long getInitialSuspendDuration() {
        return this.initialSuspendDuration;
    }

    public void setInitialSuspendDuration(long initialSuspendDuration) {
        this.initialSuspendDuration = initialSuspendDuration;
    }

    public int getTraceState() {
        return this.traceState;
    }

    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    public float getSuspendProgressionFactor() {
        return this.suspendProgressionFactor;
    }

    public void setSuspendProgressionFactor(float suspendProgressionFactor) {
        this.suspendProgressionFactor = suspendProgressionFactor;
    }

    public long getSuspendMaximumDuration() {
        return this.suspendMaximumDuration;
    }

    public void setSuspendMaximumDuration(long suspendMaximumDuration) {
        this.suspendMaximumDuration = suspendMaximumDuration;
    }

    public int getRetriesOnTimeoutBeforeSuspend() {
        return this.retriesOnTimeoutBeforeSuspend;
    }

    public void setRetriesOnTimeoutBeforeSuspend(int retriesOnTimeoutBeforeSuspend) {
        this.retriesOnTimeoutBeforeSuspend = retriesOnTimeoutBeforeSuspend;
    }

    public int getRetryDurationOnTimeout() {
        return this.retryDurationOnTimeout;
    }

    public void setRetryDurationOnTimeout(int retryDurationOnTimeout) {
        this.retryDurationOnTimeout = retryDurationOnTimeout;
    }

    public List<Integer> getSuspendErrorCodes() {
        return this.suspendErrorCodes;
    }

    public List<Integer> getTimeoutErrorCodes() {
        return this.timeoutErrorCodes;
    }

    public List<Integer> getRetryDisabledErrorCodes() {
        return this.retryDisabledErrorCodes;
    }

    public boolean isReplicationDisabled() {
        return this.replicationDisabled;
    }

    public void setReplicationDisabled(boolean replicationDisabled) {
        this.replicationDisabled = replicationDisabled;
    }

    public void addSuspendErrorCode(int code) {
        this.suspendErrorCodes.add(code);
    }

    public void addTimeoutErrorCode(int code) {
        this.timeoutErrorCodes.add(code);
    }

    public void addRetryDisabledErrorCode(int code) {
        this.retryDisabledErrorCodes.add(code);
    }

    public String toString() {
        if (this.leafEndpoint != null) {
            return this.leafEndpoint.toString();
        }
        if (this.address != null) {
            return "Address [" + this.address + "]";
        }
        return "[unknown endpoint]";
    }

    public void setLeafEndpoint(Endpoint leafEndpoint) {
        this.leafEndpoint = leafEndpoint;
    }

    public boolean isStatisticsEnable() {
        return this.aspectConfiguration != null && this.aspectConfiguration.isStatisticsEnable();
    }

    public void disableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.disableStatistics();
        }
    }

    public void enableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.enableStatistics();
        }
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }
}

