/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcher
implements Dispatcher {
    protected Log log = LogFactory.getLog(this.getClass());
    private static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";

    protected AbstractDispatcher() {
    }

    @Override
    public List<Endpoint> getEndpoints(SessionInformation sessionInformation) {
        return SALSessions.getInstance().getChildEndpoints(sessionInformation);
    }

    protected String extractSessionID(OMElement header, QName keyQName) {
        OMElement sgcIDElm = this.getHeaderBlock(header, keyQName);
        if (sgcIDElm != null) {
            String sgcID = sgcIDElm.getText();
            if (sgcID != null && !"".equals(sgcID)) {
                return sgcID.trim();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(keyQName + " is null or empty"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Couldn't find the " + keyQName + " SOAP header to find the session"));
        }
        return null;
    }

    protected String extractSessionID(MessageContext synCtx, String key) {
        if (key != null) {
            Map headerMap = this.getTransportHeaderMap(synCtx);
            if (headerMap != null) {
                Object cookieObj;
                Object hostObj = headerMap.get("Host");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("A request received with the Host Name : " + hostObj));
                }
                if ((cookieObj = headerMap.get(key)) instanceof String) {
                    String[] sessionIds;
                    String cookie = (String)cookieObj;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cookies String : " + cookie));
                    }
                    if ((sessionIds = cookie.split(";")) == null || sessionIds.length == 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Cannot find a session id for the cookie : " + cookie));
                        }
                        return null;
                    }
                    for (String sessionId : sessionIds) {
                        if (sessionId == null || sessionId.indexOf("JSESSIONID") == -1) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Extracted SessionID : " + sessionId));
                        }
                        return sessionId.trim();
                    }
                    return null;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Couldn't find the " + key + " header to find the session"));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Couldn't find the TRANSPORT_HEADERS to find the session");
            }
        }
        return null;
    }

    protected void removeSessionID(MessageContext synCtx, String key) {
        Map headerMap;
        if (key != null && (headerMap = this.getTransportHeaderMap(synCtx)) != null) {
            headerMap.remove(key);
        }
    }

    protected void removeSessionID(OMElement header, QName keyQName) {
        OMElement sgcIDElm = this.getHeaderBlock(header, keyQName);
        if (sgcIDElm != null) {
            sgcIDElm.detach();
        }
    }

    private Map getTransportHeaderMap(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    private OMElement getHeaderBlock(OMElement soapHeader, QName keyQName) {
        if (soapHeader != null) {
            return soapHeader.getFirstChildWithName(keyQName);
        }
        return null;
    }
}

