/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;

public class MediatorLog
implements SynapseLog {
    private static final Log traceLog = LogFactory.getLog((String)"TRACE_LOGGER");
    private final Log defaultLog;
    private final boolean traceOn;
    private final MessageContext synCtx;

    public MediatorLog(Log defaultLog, boolean traceOn, MessageContext synCtx) {
        this.defaultLog = defaultLog;
        this.traceOn = traceOn;
        this.synCtx = synCtx;
    }

    public boolean isTraceOrDebugEnabled() {
        return this.traceOn || this.defaultLog.isDebugEnabled();
    }

    public void traceOrDebug(Object msg) {
        if (this.traceOn) {
            traceLog.info(msg);
        }
        this.defaultLog.debug(msg);
    }

    public void traceOrDebugWarn(Object msg) {
        if (this.traceOn) {
            traceLog.warn(msg);
        }
        if (this.defaultLog.isDebugEnabled()) {
            this.defaultLog.warn(msg);
        }
    }

    public boolean isTraceTraceEnabled() {
        return this.traceOn && traceLog.isTraceEnabled();
    }

    public void traceTrace(Object msg) {
        if (this.traceOn) {
            traceLog.trace(msg);
        }
    }

    public void auditLog(Object msg) {
        this.defaultLog.info(msg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().info(msg);
        }
        if (this.traceOn) {
            traceLog.info(msg);
        }
    }

    public void auditDebug(Object msg) {
        this.defaultLog.debug(msg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().debug(msg);
        }
        if (this.traceOn) {
            traceLog.debug(msg);
        }
    }

    public void auditTrace(Object msg) {
        this.defaultLog.trace(msg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().trace(msg);
        }
        if (this.traceOn) {
            traceLog.trace(msg);
        }
    }

    public void auditWarn(Object msg) {
        this.defaultLog.warn(msg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().warn(msg);
        }
        if (this.traceOn) {
            traceLog.warn(msg);
        }
    }

    public void auditError(Object msg) {
        this.defaultLog.error(msg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().error(msg);
        }
        if (this.traceOn) {
            traceLog.error(msg);
        }
    }

    public void auditFatal(Object msg) {
        this.defaultLog.fatal(msg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().fatal(msg);
        }
        if (this.traceOn) {
            traceLog.fatal(msg);
        }
    }

    public void error(Object msg) {
        this.defaultLog.error(msg);
        if (this.traceOn) {
            traceLog.error(msg);
        }
    }

    public void logSynapseException(String msg, Throwable cause) {
        this.defaultLog.error((Object)msg, cause);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().error((Object)msg, cause);
        }
        if (this.traceOn) {
            traceLog.error((Object)msg, cause);
        }
    }
}

