/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.FixedByteArrayOutputStream;
import org.apache.synapse.util.MessageHelper;
import org.w3c.dom.Element;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CachedObject;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.digest.DigestGenerator;

public class CacheMediator
extends AbstractMediator
implements ManagedLifecycle {
    private String id = null;
    private String scope = "per-host";
    private boolean collector = false;
    private DigestGenerator digestGenerator = CachingConstants.DEFAULT_XML_IDENTIFIER;
    private int inMemoryCacheSize = 1000;
    private int diskCacheSize = 0;
    private long timeout = 0L;
    private SequenceMediator onCacheHitSequence = null;
    private String onCacheHitRef = null;
    private int maxMessageSize = 0;
    private static final String CACHE_KEY_PREFIX = "synapse.cache_key_";
    private String cacheKey = "synapse.cache_key";

    public void init(SynapseEnvironment se) {
        if (this.onCacheHitSequence != null) {
            this.onCacheHitSequence.init(se);
        }
    }

    public void destroy() {
        if (this.onCacheHitSequence != null) {
            this.onCacheHitSequence.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        CacheManager cacheManager;
        Object prop;
        ConfigurationContext cfgCtx;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Cache mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (this.maxMessageSize > 0) {
            FixedByteArrayOutputStream fbaos = new FixedByteArrayOutputStream(this.maxMessageSize);
            try {
                MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()).serialize((OutputStream)fbaos);
            }
            catch (XMLStreamException e) {
                this.handleException("Error in checking the message size", e, synCtx);
            }
            catch (SynapseException syne) {
                synLog.traceOrDebug("Message size exceeds the upper bound for caching, request will not be cached");
                return true;
            }
        }
        if ((cfgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext()) == null) {
            this.handleException("Unable to perform caching,  ConfigurationContext cannot be found", synCtx);
            return false;
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Looking up cache at scope : " + this.scope + " with ID : " + this.cacheKey);
        }
        if ((prop = cfgCtx.getPropertyNonReplicable("cacheManager")) != null && prop instanceof CacheManager) {
            cacheManager = (CacheManager)prop;
        } else {
            ConfigurationContext configurationContext = cfgCtx;
            synchronized (configurationContext) {
                prop = cfgCtx.getPropertyNonReplicable("cacheManager");
                if (prop != null && prop instanceof CacheManager) {
                    cacheManager = (CacheManager)prop;
                } else {
                    synLog.traceOrDebug("Creating/recreating the cache object");
                    cacheManager = new CacheManager();
                    cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                }
            }
        }
        boolean result = true;
        try {
            if (synCtx.isResponse()) {
                this.processResponseMessage(synCtx, cfgCtx, synLog, cacheManager);
            } else {
                result = this.processRequestMessage(synCtx, cfgCtx, synLog, cacheManager);
            }
        }
        catch (ClusteringFault clusteringFault) {
            synLog.traceOrDebug("Unable to replicate Cache mediator state among the cluster");
        }
        synLog.traceOrDebug("End : Cache mediator");
        return result;
    }

    private void processResponseMessage(MessageContext synCtx, ConfigurationContext cfgCtx, SynapseLog synLog, CacheManager cacheManager) throws ClusteringFault {
        String requestHash;
        if (!this.collector) {
            this.handleException("Response messages cannot be handled in a non collector cache", synCtx);
        }
        if ((requestHash = (String)synCtx.getProperty("requestHash")) != null) {
            CachedObject cachedObj;
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Storing the response message into the cache at scope : " + this.scope + " with ID : " + this.cacheKey + " for request hash : " + requestHash);
            }
            if ((cachedObj = cacheManager.getResponseForKey(this.cacheKey, requestHash, (AbstractContext)cfgCtx)) != null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Storing the response for the message with ID : " + synCtx.getMessageID() + " with request hash ID : " + cachedObj.getRequestHash() + " in the cache : " + this.cacheKey);
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                try {
                    MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()).serialize((OutputStream)outStream);
                    cachedObj.setResponseEnvelope(outStream.toByteArray());
                }
                catch (XMLStreamException e) {
                    this.handleException("Unable to set the response to the Cache", e, synCtx);
                }
                if (cachedObj.getTimeout() > 0L) {
                    cachedObj.setExpireTimeMillis(System.currentTimeMillis() + cachedObj.getTimeout());
                }
                cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                Replicator.replicate((AbstractContext)cfgCtx);
            } else {
                synLog.auditWarn("A response message without a valid mapping to the request hash found. Unable to store the response in cache");
            }
        } else {
            synLog.auditWarn("A response message without a mapping to the request hash found. Unable to store the response in cache");
        }
    }

    private boolean processRequestMessage(MessageContext synCtx, ConfigurationContext cfgCtx, SynapseLog synLog, CacheManager cacheManager) throws ClusteringFault {
        if (this.collector) {
            this.handleException("Request messages cannot be handled in a collector cache", synCtx);
        }
        String requestHash = null;
        try {
            requestHash = this.digestGenerator.getDigest(((Axis2MessageContext)synCtx).getAxis2MessageContext());
            synCtx.setProperty("requestHash", requestHash);
        }
        catch (CachingException e) {
            this.handleException("Error in calculating the hash value of the request", (Exception)((Object)e), synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Generated request hash : " + requestHash);
        }
        if (cacheManager.containsKey(this.cacheKey, requestHash) && cacheManager.getResponseForKey(this.cacheKey, requestHash, (AbstractContext)cfgCtx) != null) {
            CachedObject cachedObj = cacheManager.getResponseForKey(this.cacheKey, requestHash, (AbstractContext)cfgCtx);
            if (!cachedObj.isExpired() && cachedObj.getResponseEnvelope() != null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Cache-hit for message ID : " + synCtx.getMessageID());
                }
                synCtx.setResponse(true);
                try {
                    SOAPMessage smsg;
                    MessageFactory mf = MessageFactory.newInstance();
                    if (synCtx.isSOAP11()) {
                        smsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(cachedObj.getResponseEnvelope()));
                    } else {
                        MimeHeaders mimeHeaders = new MimeHeaders();
                        mimeHeaders.addHeader("Content-ID", IDGenerator.generateID());
                        mimeHeaders.addHeader("content-type", "application/soap+xml");
                        smsg = mf.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(cachedObj.getResponseEnvelope()));
                    }
                    if (smsg != null) {
                        SOAPEnvelope omSOAPEnv = SAAJUtil.toOMSOAPEnvelope((Element)smsg.getSOAPPart().getDocumentElement());
                        synCtx.setEnvelope(omSOAPEnv);
                    } else {
                        this.handleException("Unable to serve from the cache : Couldn't build the SOAP response from the cached byte stream", synCtx);
                    }
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheKey, synCtx);
                }
                catch (IOException ioe) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheKey, ioe, synCtx);
                }
                catch (SOAPException soape) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheKey, (Exception)((Object)soape), synCtx);
                }
                if (this.onCacheHitSequence != null) {
                    synLog.traceOrDebug("Delegating message to the onCachingHit Anonymous sequence");
                    this.onCacheHitSequence.mediate(synCtx);
                } else if (this.onCacheHitRef != null) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Delegating message to the onCachingHit sequence : " + this.onCacheHitRef);
                    }
                    synCtx.getSequence(this.onCacheHitRef).mediate(synCtx);
                } else {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Request message " + synCtx.getMessageID() + " was served from the cache : " + this.cacheKey);
                    }
                    synCtx.setTo(null);
                    Axis2Sender.sendBack(synCtx);
                }
                return false;
            }
            cachedObj.expire();
            cachedObj.setTimeout(this.timeout);
            synLog.traceOrDebug("Existing cached response has expired. Reset cache element");
            cfgCtx.setProperty("cacheManager", (Object)cacheManager);
            Replicator.replicate((AbstractContext)cfgCtx);
        } else if (cacheManager.getCacheKeys(this.cacheKey).size() == this.inMemoryCacheSize) {
            cacheManager.removeExpiredResponses(this.cacheKey, (AbstractContext)cfgCtx);
            if (cacheManager.getCacheKeys(this.cacheKey).size() == this.inMemoryCacheSize) {
                synLog.traceOrDebug("In-memory cache is full. Unable to cache");
            } else {
                this.storeRequestToCache(cfgCtx, requestHash, cacheManager);
            }
        } else {
            this.storeRequestToCache(cfgCtx, requestHash, cacheManager);
        }
        return true;
    }

    private void storeRequestToCache(ConfigurationContext cfgCtx, String requestHash, CacheManager cacheManager) throws ClusteringFault {
        CachedObject cachedObj = new CachedObject();
        cachedObj.setRequestHash(requestHash);
        cachedObj.setTimeout(this.timeout);
        cacheManager.addResponseWithKey(this.cacheKey, requestHash, cachedObj, (AbstractContext)cfgCtx);
        cfgCtx.setProperty("cacheManager", (Object)cacheManager);
        Replicator.replicate((AbstractContext)cfgCtx);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
        if ("per-mediator".equals(scope)) {
            this.cacheKey = CACHE_KEY_PREFIX + this.id;
        }
    }

    public boolean isCollector() {
        return this.collector;
    }

    public void setCollector(boolean collector) {
        this.collector = collector;
    }

    public DigestGenerator getDigestGenerator() {
        return this.digestGenerator;
    }

    public void setDigestGenerator(DigestGenerator digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    public int getInMemoryCacheSize() {
        return this.inMemoryCacheSize;
    }

    public void setInMemoryCacheSize(int inMemoryCacheSize) {
        this.inMemoryCacheSize = inMemoryCacheSize;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
    }

    public long getTimeout() {
        return this.timeout / 1000L;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout * 1000L;
    }

    public SequenceMediator getOnCacheHitSequence() {
        return this.onCacheHitSequence;
    }

    public void setOnCacheHitSequence(SequenceMediator onCacheHitSequence) {
        this.onCacheHitSequence = onCacheHitSequence;
    }

    public String getOnCacheHitRef() {
        return this.onCacheHitRef;
    }

    public void setOnCacheHitRef(String onCacheHitRef) {
        this.onCacheHitRef = onCacheHitRef;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

