/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class CalloutMediator
extends AbstractMediator
implements ManagedLifecycle {
    private ConfigurationContext configCtx = null;
    private String serviceURL = null;
    private String action = null;
    private String requestKey = null;
    private SynapseXPath requestXPath = null;
    private SynapseXPath targetXPath = null;
    private String targetKey = null;
    private String clientRepository = null;
    private String axis2xml = null;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";

    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Callout mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        try {
            ServiceClient sc = new ServiceClient(this.configCtx, null);
            Options options = new Options();
            options.setTo(new EndpointReference(this.serviceURL));
            if (this.action != null) {
                options.setAction(this.action);
            } else if (synCtx.isSOAP11()) {
                options.setProperty("disableSoapAction", (Object)true);
            } else {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getTransportOut().addParameter(new Parameter("OmitSOAP12Action", (Object)true));
            }
            options.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            sc.setOptions(options);
            OMElement request = this.getRequestPayload(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("About to invoke service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""));
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Request message payload : " + request);
                }
            }
            OMElement result = null;
            try {
                options.setCallTransportCleanup(true);
                result = sc.sendReceive(request);
            }
            catch (AxisFault axisFault) {
                this.handleFault(synCtx, axisFault);
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Response payload received : " + result);
            }
            if (result != null) {
                if (this.targetXPath != null) {
                    Object o = this.targetXPath.evaluate(synCtx);
                    if (o != null && o instanceof OMElement) {
                        OMElement tgtNode = (OMElement)o;
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else if (o != null && o instanceof List && !((List)o).isEmpty()) {
                        OMElement tgtNode = (OMElement)((List)o).get(0);
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else {
                        this.handleException("Evaluation of target XPath expression : " + this.targetXPath.toString() + " did not yeild an OMNode", synCtx);
                    }
                }
                if (this.targetKey != null) {
                    synCtx.setProperty(this.targetKey, result);
                }
            } else {
                synLog.traceOrDebug("Service returned a null response");
            }
        }
        catch (AxisFault e) {
            this.handleException("Error invoking service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""), (Exception)((Object)e), synCtx);
        }
        catch (JaxenException e) {
            this.handleException("Error while evaluating the XPath expression: " + (Object)((Object)this.targetXPath), (Exception)((Object)e), synCtx);
        }
        synLog.traceOrDebug("End : Callout mediator");
        return true;
    }

    private void handleFault(MessageContext synCtx, AxisFault axisFault) {
        synCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
        if (axisFault.getFaultCodeElement() != null) {
            synCtx.setProperty("ERROR_CODE", axisFault.getFaultCodeElement().getText());
        } else {
            synCtx.setProperty("ERROR_CODE", 401000);
        }
        if (axisFault.getFaultReasonElement() != null) {
            synCtx.setProperty("ERROR_MESSAGE", axisFault.getFaultReasonElement().getText());
        } else {
            synCtx.setProperty("ERROR_MESSAGE", "Error while performing the callout operation");
        }
        if (axisFault.getFaultDetailElement() != null) {
            if (axisFault.getFaultDetailElement().getFirstElement() != null) {
                synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getFirstElement());
            } else {
                synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getText());
            }
        }
        synCtx.setProperty("ERROR_EXCEPTION", (Object)axisFault);
        throw new SynapseException("Error while performing the callout operation", axisFault);
    }

    private OMElement getRequestPayload(MessageContext synCtx) throws AxisFault {
        if (this.requestKey != null) {
            Object request = synCtx.getProperty(this.requestKey);
            if (request == null) {
                request = synCtx.getEntry(this.requestKey);
            }
            if (request != null && request instanceof OMElement) {
                return (OMElement)request;
            }
            this.handleException("The property : " + this.requestKey + " is not an OMElement", synCtx);
        } else if (this.requestXPath != null) {
            try {
                Object o = this.requestXPath.evaluate(MessageHelper.cloneMessageContext(synCtx));
                if (o instanceof OMElement) {
                    return (OMElement)o;
                }
                if (o instanceof List && !((List)o).isEmpty()) {
                    return (OMElement)((List)o).get(0);
                }
                this.handleException("The evaluation of the XPath expression : " + this.requestXPath.toString() + " did not result in an OMElement", synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.requestXPath.toString(), (Exception)((Object)e), synCtx);
            }
        }
        return null;
    }

    public void init(SynapseEnvironment synEnv) {
        try {
            this.configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
        }
        catch (AxisFault e) {
            String msg = "Error initializing callout mediator : " + e.getMessage();
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    public void destroy() {
        try {
            this.configCtx.terminate();
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public void setRequestXPath(SynapseXPath requestXPath) throws JaxenException {
        this.requestXPath = requestXPath;
    }

    public void setTargetXPath(SynapseXPath targetXPath) throws JaxenException {
        this.targetXPath = targetXPath;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public SynapseXPath getRequestXPath() {
        return this.requestXPath;
    }

    public SynapseXPath getTargetXPath() {
        return this.targetXPath;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }
}

