/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private SynapseXPath xpath = null;
    private String property = null;
    private int targetType = 0;
    public static final String ACTION_REPLACE = "replace";
    public static final String ACTION_ADD_CHILD = "child";
    public static final String ACTION_ADD_SIBLING = "sibling";
    private String action = "replace";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(MessageContext synContext, ArrayList<OMNode> sourceNodeList, SynapseLog synLog) throws JaxenException {
        SOAPBody body;
        if (this.targetType == 0) {
            assert (this.xpath != null) : "Xpath cannot be null for CUSTOM";
            if (sourceNodeList.isEmpty()) {
                synLog.error("Cannot Enrich message from an empty source.");
                return;
            }
            Object targetObj = this.xpath.selectSingleNode(synContext);
            if (targetObj instanceof OMElement) {
                OMElement targetElem = (OMElement)targetObj;
                this.insertElement(sourceNodeList, targetElem, synLog);
                return;
            }
            if (!(targetObj instanceof OMText)) {
                synLog.error("Invalid Target object to be enrich.");
                throw new SynapseException("Invalid Target object to be enrich.");
            }
            OMText targetText = (OMText)targetObj;
            if (sourceNodeList.get(0) instanceof OMText) {
                if (targetText.getParent() == null) return;
                OMContainer parent = targetText.getParent();
                if (!(parent instanceof OMElement)) return;
                ((OMElement)parent).setText(((OMText)sourceNodeList.get(0)).getText());
                return;
            }
            if (!(sourceNodeList.get(0) instanceof OMElement)) return;
            OMContainer targetParent = targetText.getParent();
            if (!(targetParent instanceof OMElement)) return;
            targetText.detach();
            ((OMElement)targetParent).addChild(sourceNodeList.get(0));
            return;
        }
        if (this.targetType == 2) {
            SOAPEnvelope env = synContext.getEnvelope();
            body = env.getBody();
            OMElement e = body.getFirstElement();
            if (e != null) {
                this.insertElement(sourceNodeList, e, synLog);
                return;
            }
        } else {
            if (this.targetType == 1) {
                OMNode node = sourceNodeList.get(0);
                if (!(node instanceof SOAPEnvelope)) {
                    synLog.error("SOAPEnvelope is expected");
                    throw new SynapseException("A SOAPEnvelope is expected");
                }
                try {
                    synContext.setEnvelope((SOAPEnvelope)node);
                    return;
                }
                catch (AxisFault axisFault) {
                    synLog.error("Failed to set the SOAP Envelope");
                    throw new SynapseException("Failed to set the SOAP Envelope");
                }
            }
            if (this.targetType != 3) return;
            assert (this.property != null) : "Property cannot be null for PROPERTY type";
            synContext.setProperty(this.property, sourceNodeList);
            return;
        }
        Iterator<OMNode> i$ = sourceNodeList.iterator();
        while (i$.hasNext()) {
            OMNode elem = i$.next();
            if (elem instanceof OMElement) {
                body.addChild(elem);
                continue;
            }
            synLog.error("Invalid Object type to be inserted into message body");
        }
    }

    private void insertElement(ArrayList<OMNode> sourceNodeList, OMElement e, SynapseLog synLog) {
        block9: {
            block8: {
                if (!this.action.equals(ACTION_REPLACE)) break block8;
                boolean isInserted = false;
                for (OMNode elem : sourceNodeList) {
                    if (elem instanceof OMElement) {
                        e.insertSiblingAfter(elem);
                        isInserted = true;
                        continue;
                    }
                    if (elem instanceof OMText) {
                        e.setText(((OMText)elem).getText());
                        continue;
                    }
                    synLog.error("Invalid Source object to be inserted.");
                }
                if (!isInserted) break block9;
                e.detach();
                break block9;
            }
            if (this.action.equals(ACTION_ADD_CHILD)) {
                for (OMNode elem : sourceNodeList) {
                    if (!(elem instanceof OMElement)) continue;
                    e.addChild(elem);
                }
            } else if (this.action.equals(ACTION_ADD_SIBLING)) {
                for (OMNode elem : sourceNodeList) {
                    if (!(elem instanceof OMElement)) continue;
                    e.insertSiblingAfter(elem);
                }
            }
        }
    }

    public SynapseXPath getXpath() {
        return this.xpath;
    }

    public String getProperty() {
        return this.property;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

