/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.registry;

import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.registry.RegistryEntry;

public abstract class AbstractRegistry
implements Registry {
    private static final Log log = LogFactory.getLog(AbstractRegistry.class);
    protected final Properties properties = new Properties();

    public Object getResource(Entry entry, Properties properties) {
        OMNode omNode = null;
        RegistryEntry re = null;
        if (entry.isCached() && !entry.isExpired()) {
            return entry.getValue();
        }
        if (!entry.isCached()) {
            omNode = this.lookup(entry.getKey());
            entry.setEntryProperties(this.getResourceProperties(entry.getKey()));
            if (omNode == null && entry.getEntryProperties() != null && !entry.getEntryProperties().isEmpty() && (re = this.getRegistryEntry(entry.getKey())) != null) {
                if (re.getCachableDuration() > 0L) {
                    entry.setExpiryTime(System.currentTimeMillis() + re.getCachableDuration());
                } else {
                    entry.setExpiryTime(-1L);
                }
                entry.setVersion(re.getVersion());
            }
            if (omNode == null) {
                return null;
            }
            re = this.getRegistryEntry(entry.getKey());
        } else if (entry.isExpired()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cached object has expired for key : " + entry.getKey()));
            }
            if ((re = this.getRegistryEntry(entry.getKey())).getVersion() != Long.MIN_VALUE && re.getVersion() == entry.getVersion()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Expired version number is same as current version in registry");
                }
                if (re.getCachableDuration() > 0L) {
                    entry.setExpiryTime(System.currentTimeMillis() + re.getCachableDuration());
                } else {
                    entry.setExpiryTime(-1L);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Renew cache lease for another " + re.getCachableDuration() / 1000L + "s"));
                }
                return entry.getValue();
            }
            omNode = this.lookup(entry.getKey());
            entry.setEntryProperties(this.getResourceProperties(entry.getKey()));
            if (omNode == null && entry.getEntryProperties() != null && !entry.getEntryProperties().isEmpty() && (re = this.getRegistryEntry(entry.getKey())) != null) {
                if (re.getCachableDuration() > 0L) {
                    entry.setExpiryTime(System.currentTimeMillis() + re.getCachableDuration());
                } else {
                    entry.setExpiryTime(-1L);
                }
                entry.setVersion(re.getVersion());
            }
            if (omNode == null) {
                return null;
            }
        }
        Object expiredValue = entry.getValue();
        if (entry.getMapper() != null) {
            entry.setValue(entry.getMapper().getObjectFromOMNode(omNode, properties));
            if (entry.getValue() instanceof SequenceMediator) {
                SequenceMediator seq = (SequenceMediator)entry.getValue();
                seq.setDynamic(true);
                seq.setRegistryKey(entry.getKey());
            } else if (entry.getValue() instanceof Endpoint) {
                Endpoint ep = (Endpoint)entry.getValue();
            }
        } else if (re != null && re.getType() != null) {
            XMLToObjectMapper mapper = this.getMapper(re.getType());
            if (mapper != null) {
                entry.setMapper(mapper);
                entry.setValue(mapper.getObjectFromOMNode(omNode, properties));
            } else {
                entry.setValue(omNode);
            }
        }
        if (expiredValue != null) {
            if (expiredValue instanceof SequenceMediator) {
                ((SequenceMediator)expiredValue).destroy();
            } else if (expiredValue instanceof Endpoint) {
                ((Endpoint)expiredValue).destroy();
            }
        }
        if (re != null) {
            if (re.getCachableDuration() > 0L) {
                entry.setExpiryTime(System.currentTimeMillis() + re.getCachableDuration());
            } else {
                entry.setExpiryTime(-1L);
            }
            entry.setVersion(re.getVersion());
        }
        return entry.getValue();
    }

    private XMLToObjectMapper getMapper(String type) {
        return null;
    }

    public String getProviderClass() {
        return this.getClass().getName();
    }

    public Properties getConfigurationProperties() {
        return this.properties;
    }

    public void init(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public Properties getResourceProperties(String entryKey) {
        return null;
    }
}

