/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.AbstractRESTProcessor;
import org.apache.synapse.rest.Handler;
import org.apache.synapse.rest.RESTUtils;
import org.apache.synapse.rest.Resource;
import org.apache.synapse.rest.dispatch.DispatcherHelper;
import org.apache.synapse.rest.dispatch.RESTDispatcher;

public class API
extends AbstractRESTProcessor
implements ManagedLifecycle {
    private String host;
    private int port = -1;
    private String context;
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private List<Handler> handlers = new ArrayList<Handler>();
    private String fileName;

    public API(String name, String context) {
        super(name);
        if (!context.startsWith("/")) {
            this.handleException("API context must begin with '/' character");
        }
        this.context = RESTUtils.trimTrailingSlashes(context);
    }

    public String getName() {
        return this.name;
    }

    public String getContext() {
        return this.context;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void addResource(Resource resource) {
        DispatcherHelper dispatcherHelper = resource.getDispatcherHelper();
        if (dispatcherHelper != null) {
            String mapping = dispatcherHelper.getString();
            for (Resource r : this.resources.values()) {
                DispatcherHelper helper = r.getDispatcherHelper();
                if (helper == null || !helper.getString().equals(mapping) || !this.resourceMatches(resource, r)) continue;
                this.handleException("Two resources cannot have the same path mapping and methods");
            }
        } else {
            for (Resource r : this.resources.values()) {
                DispatcherHelper helper = r.getDispatcherHelper();
                if (helper != null) continue;
                this.handleException("Only one resource can be designated as default");
            }
        }
        this.resources.put(resource.getName(), resource);
    }

    private boolean resourceMatches(Resource r1, Resource r2) {
        String[] methods1 = r1.getMethods();
        String[] methods2 = r2.getMethods();
        for (String m1 : methods1) {
            for (String m2 : methods2) {
                if (!m1.equals(m2)) continue;
                return true;
            }
        }
        return false;
    }

    public Resource[] getResources() {
        return this.resources.values().toArray(new Resource[this.resources.size()]);
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[this.handlers.size()]);
    }

    boolean canProcess(MessageContext synCtx) {
        if (synCtx.isResponse()) {
            String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
            if (!this.name.equals(apiName)) {
                return false;
            }
        } else {
            String path = RESTUtils.getFullRequestPath(synCtx);
            if (!(path.startsWith(this.context + "/") || path.startsWith(this.context + "?") || this.context.equals(path) || "/".equals(this.context))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("API context: " + this.context + " does not match request URI: " + path));
                }
                return false;
            }
            if (this.host != null || this.port != -1) {
                org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                String hostHeader = this.getHostHeader(msgCtx);
                if (hostHeader != null) {
                    if (this.host != null && !this.host.equals(this.extractHostName(hostHeader))) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("API host: " + this.host + " does not match host information " + "in the request: " + hostHeader));
                        }
                        return false;
                    }
                    if (this.port != -1 && this.port != this.extractPortNumber(hostHeader, msgCtx.getIncomingTransportName())) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("API port: " + this.port + " does not match port information " + "in the request: " + hostHeader));
                        }
                        return false;
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Host information not available on the message");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    void process(MessageContext synCtx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing message with ID: " + synCtx.getMessageID() + " through the " + "API: " + this.name));
        }
        for (Handler handler : this.handlers) {
            boolean proceed;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing message with ID: " + synCtx.getMessageID() + " through " + "handler: " + handler.getClass().getName()));
            }
            if (proceed = synCtx.isResponse() ? handler.handleResponse(synCtx) : handler.handleRequest(synCtx)) continue;
            return;
        }
        if (synCtx.isResponse()) {
            String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
            if (resourceName != null) {
                Resource resource = this.resources.get(resourceName);
                if (resource != null) {
                    resource.process(synCtx);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No resource information on the response: " + synCtx.getMessageID()));
            }
            return;
        }
        synCtx.setProperty("SYNAPSE_REST_API", this.name);
        synCtx.setProperty("REST_API_CONTEXT", this.context);
        String path = RESTUtils.getFullRequestPath(synCtx);
        String subPath = path.substring(this.context.length());
        if ("".equals(subPath)) {
            subPath = "/";
        }
        synCtx.setProperty("REST_SUB_REQUEST_PATH", subPath);
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String hostHeader = this.getHostHeader(msgCtx);
        if (hostHeader != null) {
            synCtx.setProperty("REST_URL_PREFIX", msgCtx.getIncomingTransportName() + "://" + hostHeader);
        }
        HashSet<Resource> acceptableResources = new HashSet<Resource>();
        for (Resource r : this.resources.values()) {
            if (!r.canProcess(synCtx)) continue;
            acceptableResources.add(r);
        }
        boolean processed = false;
        if (!acceptableResources.isEmpty()) {
            for (RESTDispatcher dispatcher : RESTUtils.getDispatchers()) {
                Resource resource = dispatcher.findResource(synCtx, acceptableResources);
                if (resource == null) continue;
                resource.process(synCtx);
                processed = true;
                break;
            }
        }
        if (!processed && this.log.isDebugEnabled()) {
            this.log.debug((Object)("No matching resource was found for the request: " + synCtx.getMessageID()));
        }
    }

    private String getHostHeader(org.apache.axis2.context.MessageContext msgCtx) {
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String hostHeader = null;
        if (transportHeaders != null) {
            hostHeader = (String)transportHeaders.get("Host");
        }
        if (hostHeader == null) {
            hostHeader = (String)msgCtx.getProperty("SERVICE_PREFIX");
        }
        return hostHeader;
    }

    private String extractHostName(String hostHeader) {
        int index = hostHeader.indexOf(58);
        if (index != -1) {
            return hostHeader.substring(0, index);
        }
        return hostHeader;
    }

    private int extractPortNumber(String hostHeader, String transport) {
        int index = hostHeader.indexOf(58);
        if (index != -1) {
            return Integer.parseInt(hostHeader.substring(index + 1));
        }
        if ("http".equals(transport)) {
            return 80;
        }
        return 443;
    }

    public void init(SynapseEnvironment se) {
        if (this.resources.isEmpty()) {
            this.handleException("The API: " + this.name + " has been configured without " + "any resource definitions");
        }
        this.log.info((Object)("Initializing API: " + this.name));
        for (Resource resource : this.resources.values()) {
            resource.init(se);
        }
    }

    public void destroy() {
        this.log.info((Object)("Destroying API: " + this.name));
        for (Resource resource : this.resources.values()) {
            resource.destroy();
        }
    }
}

