/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.task.Task;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SimpleQuartzJob
implements Job {
    public static final String SYNAPSE_ENVIRONMENT = "SynapseEnvironment";
    public static final String CLASSNAME = "ClassName";
    public static final String PROPERTIES = "Properties";
    private static final Log log = LogFactory.getLog(SimpleQuartzJob.class);

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        JobDataMap jdm;
        String jobClassName;
        String jobName = ctx.getJobDetail().getFullName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing task : " + jobName));
        }
        if ((jobClassName = (String)(jdm = ctx.getMergedJobDataMap()).get((Object)CLASSNAME)) == null) {
            this.handleException("No ClassName in JobDetails");
        }
        boolean initRequired = false;
        Task task = (Task)jdm.get((Object)"Instance");
        if (task == null) {
            initRequired = true;
        }
        SynapseEnvironment se = (SynapseEnvironment)jdm.get((Object)SYNAPSE_ENVIRONMENT);
        if (initRequired) {
            try {
                task = (Task)this.getClass().getClassLoader().loadClass(jobClassName).newInstance();
            }
            catch (Exception e) {
                this.handleException("Cannot instantiate task : " + jobClassName, e);
            }
            Set properties = (Set)jdm.get((Object)PROPERTIES);
            for (Object property : properties) {
                OMElement prop = (OMElement)property;
                log.debug((Object)("Found Property : " + prop.toString()));
                PropertyHelper.setStaticProperty((OMElement)prop, (Object)task);
            }
            if (task instanceof ManagedLifecycle && se != null) {
                ((ManagedLifecycle)task).init(se);
            }
        }
        if (se != null && task != null && se.isInitialized()) {
            task.execute();
        }
        if (initRequired && task instanceof ManagedLifecycle && se != null) {
            ((ManagedLifecycle)task).destroy();
        }
    }

    private void handleException(String msg) throws JobExecutionException {
        log.error((Object)msg);
        throw new JobExecutionException(msg);
    }

    private void handleException(String msg, Exception e) throws JobExecutionException {
        log.error((Object)msg, (Throwable)e);
        throw new JobExecutionException(msg, (Throwable)e);
    }
}

