/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap {
    private static final Log log = LogFactory.getLog(ResourceMap.class);
    private final Map<String, String> resources = new LinkedHashMap<String, String>();

    public void addResource(String location, String key) {
        this.resources.put(location, key);
    }

    public Map<String, String> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public InputSource resolve(SynapseConfiguration synCfg, String location) {
        String key = this.resources.get(location);
        if (key == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No resource mapping is defined for location '" + location + "'"));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving location '" + location + "' to registry item '" + key + "'"));
        }
        synCfg.getEntryDefinition(key);
        Object keyObject = synCfg.getEntry(key);
        if (keyObject instanceof OMElement) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((OMElement)keyObject).serialize((OutputStream)baos);
            }
            catch (XMLStreamException ex) {
                String msg = "Unable to serialize registry item '" + key + "' for location '" + location + "'";
                log.error((Object)msg);
                throw new SynapseException(msg, ex);
            }
            InputSource inputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            inputSource.setSystemId("synapse-reg:///" + key);
            return inputSource;
        }
        String msg = "Registry item '" + key + "' for location '" + location + "' is not an OMElement";
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

