/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.PrimaryKeyEncoder;
import org.apache.tapestry.TapestryMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPrimaryKeyEncoder<K extends Serializable, V>
implements PrimaryKeyEncoder<K, V> {
    private final Map<K, V> _keyToValue = new LinkedHashMap();
    private final Map<V, K> _valueToKey = CollectionFactory.newMap();
    private Set<K> _deletedKeys;
    private K _currentKey;

    public final void add(K key, V value) {
        Defense.notNull(key, (String)"key");
        Defense.notNull(value, (String)"value");
        V existing = this._keyToValue.get(key);
        if (existing != null) {
            throw new IllegalArgumentException(TapestryMessages.duplicateKey(key, value, existing));
        }
        this._keyToValue.put(key, value);
        this._valueToKey.put(value, key);
    }

    public final List<V> getValues() {
        return this.valuesNotInKeySet(this._deletedKeys);
    }

    protected final List<V> valuesNotInKeySet(Set<K> keySet) {
        if (keySet == null || keySet.isEmpty()) {
            return this.getAllValues();
        }
        List result = CollectionFactory.newList();
        for (Map.Entry<K, V> entry : this._keyToValue.entrySet()) {
            if (keySet.contains(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public final List<V> getAllValues() {
        List result = CollectionFactory.newList();
        for (Map.Entry<K, V> entry : this._keyToValue.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    @Override
    public final K toKey(V value) {
        Defense.notNull(value, (String)"value");
        this._currentKey = (Serializable)this._valueToKey.get(value);
        if (this._currentKey == null) {
            throw new IllegalArgumentException(TapestryMessages.missingValue(value, this._valueToKey.keySet()));
        }
        return this._currentKey;
    }

    @Override
    public final V toValue(K key) {
        V result = this._keyToValue.get(key);
        if (result == null) {
            result = this.provideMissingObject(key);
            this._currentKey = key;
        } else {
            this._currentKey = key;
        }
        return result;
    }

    protected V provideMissingObject(K key) {
        return null;
    }

    public final boolean isDeleted() {
        return this.inKeySet(this._deletedKeys);
    }

    public final void setDeleted(boolean value) {
        this._deletedKeys = this.modifyKeySet(this._deletedKeys, value);
    }

    protected final boolean inKeySet(Set<K> keySet) {
        return keySet != null ? keySet.contains(this._currentKey) : false;
    }

    protected final Set<K> modifyKeySet(Set<K> keySet, boolean value) {
        if (keySet == null) {
            if (!value) {
                return null;
            }
            keySet = CollectionFactory.newSet();
        }
        if (value) {
            keySet.add(this._currentKey);
        } else {
            keySet.remove(this._currentKey);
        }
        return keySet;
    }

    @Override
    public void prepareForKeys(List<K> keys) {
    }
}

