/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.base;

import java.io.Serializable;
import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentAction;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Field;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.ValidationDecorator;
import org.apache.tapestry.ValidationException;
import org.apache.tapestry.annotations.AfterRender;
import org.apache.tapestry.annotations.BeginRender;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.annotations.Mixin;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.annotations.SetupRender;
import org.apache.tapestry.corelib.mixins.DiscardBody;
import org.apache.tapestry.corelib.mixins.RenderDisabled;
import org.apache.tapestry.corelib.mixins.RenderInformals;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.internal.bindings.LiteralBinding;
import org.apache.tapestry.internal.services.FormParameterLookup;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.BindingSource;
import org.apache.tapestry.services.FormSupport;
import org.apache.tapestry.services.PageRenderSupport;

@ComponentClass
public abstract class AbstractField
implements Field {
    @Parameter(defaultPrefix="literal")
    private String _label;
    @Parameter
    private boolean _disabled;
    @Mixin
    private RenderInformals _renderInformals;
    @Mixin
    private RenderDisabled _renderDisabled;
    @Mixin
    private DiscardBody _discardBody;
    @Environmental
    private ValidationDecorator _decorator;
    protected static final FieldValidator NOOP_VALIDATOR = new FieldValidator(){

        public void validate(Object value) throws ValidationException {
        }
    };
    private static final ProcessSubmissionAction PROCESS_SUBMISSION_ACTION = new ProcessSubmissionAction();
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    private String _assignedClientId;
    private String _elementName;
    @Environmental
    private FormSupport _formSupport;
    @Environmental
    private PageRenderSupport _pageRenderSupport;
    @Inject
    private ComponentResources _resources;
    @Inject(value="service:tapestry.internal.FormParameterLookup")
    private FormParameterLookup _paramLookup;
    @Inject(value="infrastructure:BindingSource")
    private BindingSource _bindingSource;
    @Inject(value="infrastructure:PropertyAccess")
    private PropertyAccess _propertyAccess;

    final Binding defaultLabel() {
        String componentId;
        String key;
        Messages containerMessages = this._resources.getContainer().getComponentResources().getMessages();
        String label = containerMessages.contains(key = (componentId = this._resources.getId()) + "-label") ? containerMessages.get(key) : TapestryUtils.toUserPresentable(componentId);
        return new LiteralBinding("default label", label, null);
    }

    public final String getLabel() {
        return this._label;
    }

    @SetupRender
    final void setup() {
        String id = this._clientId;
        this._assignedClientId = this._pageRenderSupport.allocateClientId(id);
        String elementName = this._formSupport.allocateElementName(id);
        this._formSupport.storeAndExecute(this, new SetupAction(elementName));
        this._formSupport.store(this, PROCESS_SUBMISSION_ACTION);
    }

    public final String getClientId() {
        return this._assignedClientId;
    }

    public final String getElementName() {
        return this._elementName;
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    private void setupElementName(String elementName) {
        this._elementName = elementName;
    }

    private void processSubmission() {
        if (!this._disabled) {
            this.processSubmission(this._paramLookup, this._elementName);
        }
    }

    protected final Binding createDefaultParameterBinding(String parameterName) {
        String componentId = this._resources.getId();
        Component container = this._resources.getContainer();
        if (this._propertyAccess.getAdapter((Object)container).getPropertyAdapter(componentId) == null) {
            return null;
        }
        ComponentResources containerResources = this._resources.getContainerResources();
        return this._bindingSource.newBinding("default " + parameterName, containerResources, componentId);
    }

    protected abstract void processSubmission(FormParameterLookup var1, String var2);

    @BeginRender
    final void beforeDecorator(MarkupWriter writer) {
        this._decorator.beforeField(this);
    }

    @AfterRender
    final void afterDecorator(MarkupWriter writer) {
        this._decorator.afterField(this);
    }

    protected final ValidationDecorator getValidationDecorator() {
        return this._decorator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProcessSubmissionAction
    implements ComponentAction<AbstractField>,
    Serializable {
        private static final long serialVersionUID = -4346426414137434418L;

        ProcessSubmissionAction() {
        }

        @Override
        public void execute(AbstractField component) {
            component.processSubmission();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetupAction
    implements ComponentAction<AbstractField>,
    Serializable {
        private static final long serialVersionUID = 2690270808212097020L;
        private final String _elementName;

        public SetupAction(String elementName) {
            this._elementName = elementName;
        }

        @Override
        public void execute(AbstractField component) {
            component.setupElementName(this._elementName);
        }
    }
}

