/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.base;

import java.util.Locale;
import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.Translator;
import org.apache.tapestry.ValidationException;
import org.apache.tapestry.ValidationTracker;
import org.apache.tapestry.annotations.BeginRender;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.corelib.base.AbstractField;
import org.apache.tapestry.internal.services.FormParameterLookup;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.services.FieldValidatorDefaultSource;
import org.apache.tapestry.services.TranslatorDefaultSource;
import org.apache.tapestry.services.ValidationMessagesSource;

public abstract class AbstractTextField
extends AbstractField {
    @Parameter(required=true, principal=true)
    private Object _value;
    @Parameter
    private Translator<Object> _translate;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> _validate = NOOP_VALIDATOR;
    @Environmental
    private ValidationTracker _tracker;
    @Inject(value="infrastructure:ValidationMessagesSource")
    private ValidationMessagesSource _messagesSource;
    @Inject(value="infrastructure:TranslatorDefaultSource")
    private TranslatorDefaultSource _translatorDefaultSource;
    @Inject(value="infrastructure:FieldValidatorDefaultSource")
    private FieldValidatorDefaultSource _fieldValidatorDefaultSource;
    @Inject
    private ComponentResources _resources;
    @Inject
    private Locale _locale;

    final Translator defaultTranslate() {
        Class type = this._resources.getBoundType("value");
        if (type == null) {
            return null;
        }
        return this._translatorDefaultSource.find(type);
    }

    final FieldValidator defaultValidate() {
        Class type = this._resources.getBoundType("value");
        if (type == null) {
            return null;
        }
        return this._fieldValidatorDefaultSource.createDefaultValidator(this, this._resources.getId(), this._resources.getContainerMessages(), this._locale, type, this._resources.getAnnotationProvider("value"));
    }

    final Binding defaultValue() {
        return this.createDefaultParameterBinding("value");
    }

    @BeginRender
    final void begin(MarkupWriter writer) {
        String value = this._tracker.getInput(this);
        if (value == null) {
            value = this._translate.toClient(this._value);
        }
        this.writeFieldTag(writer, value);
        this.getValidationDecorator().insideField(this);
    }

    protected abstract void writeFieldTag(MarkupWriter var1, String var2);

    protected final void processSubmission(FormParameterLookup paramLookup, String elementName) {
        String rawValue = paramLookup.getParameter(elementName);
        this._tracker.recordInput(this, rawValue);
        Messages messages = this._messagesSource.getValidationMessages(this._locale);
        try {
            Object translated = this._translate.parseClient(rawValue, messages);
            this._validate.validate(translated);
            this._value = translated;
        }
        catch (ValidationException ex) {
            this._tracker.recordError(this, ex.getMessage());
            return;
        }
    }
}

