/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.components;

import java.util.Locale;
import org.apache.tapestry.Block;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.EnumSelectModel;
import org.apache.tapestry.EnumValueEncoder;
import org.apache.tapestry.Field;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.SelectModel;
import org.apache.tapestry.Translator;
import org.apache.tapestry.ValueEncoder;
import org.apache.tapestry.annotations.Component;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.beaneditor.BeanEditorModel;
import org.apache.tapestry.beaneditor.PropertyEditModel;
import org.apache.tapestry.corelib.components.Checkbox;
import org.apache.tapestry.corelib.components.Form;
import org.apache.tapestry.corelib.components.Select;
import org.apache.tapestry.corelib.components.TextField;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.services.BeanEditorModelSource;
import org.apache.tapestry.services.FieldValidatorDefaultSource;
import org.apache.tapestry.services.TranslatorDefaultSource;

@ComponentClass
public class BeanEditForm {
    @Parameter(required=true)
    private Object _object;
    @Inject
    private ComponentResources _resources;
    @Inject(value="infrastructure:BeanEditorModelSource")
    private BeanEditorModelSource _modelSource;
    @Inject(value="infrastructure:TranslatorDefaultSource")
    private TranslatorDefaultSource _translatorDefaultSource;
    @Inject(value="infrastructure:FieldValidatorDefaultSource")
    private FieldValidatorDefaultSource _fieldValidatorDefaultSource;
    @Inject
    private Block _text;
    @Inject
    private Block _enum;
    @Inject
    private Block _checkbox;
    @Component
    private Form _form;
    @Component(parameters={"value=valueForProperty", "label=prop:propertyEditModel.label", "encoder=valueEncoderForProperty", "model=selectModelForProperty", "validate=prop:validateForProperty", "clientId=prop:propertyName"})
    private Select _select;
    @Component(parameters={"value=valueForProperty", "label=prop:propertyEditModel.label", "translate=prop:translateForProperty", "validate=prop:validateForProperty", "clientId=prop:propertyName"})
    private TextField _textField;
    @Component(parameters={"value=valueForProperty", "label=prop:propertyEditModel.label", "clientId=prop:propertyName"})
    private Checkbox _checkboxField;
    @Inject
    private Messages _messages;
    @Inject
    private Locale _locale;
    @Parameter
    private BeanEditorModel _model;
    private String _propertyName;
    private PropertyEditModel _propertyEditModel;
    private Block _blockForProperty;
    private Field _fieldForProperty;

    public BeanEditorModel getModel() {
        return this._model;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public void setPropertyName(String propertyName) {
        this._propertyEditModel = this._model.get(propertyName);
        this._blockForProperty = null;
        this._fieldForProperty = null;
        this._propertyName = propertyName;
        String editorType = this._propertyEditModel.getEditorType();
        if (editorType.equals("text")) {
            this._blockForProperty = this._text;
            this._fieldForProperty = this._textField;
            return;
        }
        if (editorType.equals("enum")) {
            this._blockForProperty = this._enum;
            this._fieldForProperty = this._select;
            return;
        }
        if (editorType.equals("checkbox")) {
            this._blockForProperty = this._checkbox;
            this._fieldForProperty = this._checkboxField;
            return;
        }
        throw new IllegalArgumentException(this._messages.format("no-editor", new Object[]{editorType, propertyName}));
    }

    boolean onPrepareFromForm() {
        this._resources.triggerEvent("prepare", null, null);
        if (this._model == null) {
            Class<?> beanType = this._object.getClass();
            this._model = this._modelSource.create(beanType, this._resources.getContainerResources());
        }
        return true;
    }

    public Translator getTranslateForProperty() {
        return this._translatorDefaultSource.find(this._propertyEditModel.getPropertyType());
    }

    public FieldValidator getValidateForProperty() {
        return this._fieldValidatorDefaultSource.createDefaultValidator(this._fieldForProperty, this._propertyName, this._resources.getContainerMessages(), this._locale, this._propertyEditModel.getPropertyType(), this._propertyEditModel.getConduit());
    }

    public PropertyEditModel getPropertyEditModel() {
        return this._propertyEditModel;
    }

    public Block getBlockForProperty() {
        return this._blockForProperty;
    }

    public Field getFieldForProperty() {
        return this._fieldForProperty;
    }

    public Object getValueForProperty() {
        return this._propertyEditModel.getConduit().get(this._object);
    }

    public void setValueForProperty(Object value) {
        this._propertyEditModel.getConduit().set(this._object, value);
    }

    public ValueEncoder getValueEncoderForProperty() {
        return new EnumValueEncoder(this._propertyEditModel.getPropertyType());
    }

    public SelectModel getSelectModelForProperty() {
        return new EnumSelectModel(this._propertyEditModel.getPropertyType(), this._resources.getContainerMessages());
    }

    public Form getForm() {
        return this._form;
    }
}

