/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.components;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.tapestry.ComponentAction;
import org.apache.tapestry.corelib.components.ComponentMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.IdAllocator;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.FormSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormSupportImpl
implements FormSupport {
    private final IdAllocator _idAllocator = new IdAllocator();
    private final ObjectOutputStream _actions;
    private List<Runnable> _commands;

    public FormSupportImpl() {
        this(null);
    }

    public FormSupportImpl(ObjectOutputStream actions) {
        this._actions = actions;
    }

    @Override
    public String allocateElementName(String id) {
        return this._idAllocator.allocateId(id);
    }

    @Override
    public <T> void store(T component, ComponentAction<T> action) {
        Component castComponent = (Component)Defense.cast(component, Component.class, (String)"component");
        Defense.notNull(action, (String)"action");
        String completeId = castComponent.getComponentResources().getCompleteId();
        try {
            this._actions.writeUTF(completeId);
            this._actions.writeObject(action);
        }
        catch (IOException ex) {
            throw new RuntimeException(ComponentMessages.componentActionNotSerializable(completeId, ex), ex);
        }
    }

    @Override
    public <T> void storeAndExecute(T component, ComponentAction<T> action) {
        this.store(component, action);
        action.execute(component);
    }

    @Override
    public void defer(Runnable command) {
        if (this._commands == null) {
            this._commands = CollectionFactory.newList();
        }
        this._commands.add((Runnable)Defense.notNull((Object)command, (String)"command"));
    }

    void executeDeferred() {
        if (this._commands == null) {
            return;
        }
        for (Runnable r : this._commands) {
            r.run();
        }
        this._commands.clear();
    }
}

