/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.components;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.EnumSelectModel;
import org.apache.tapestry.EnumValueEncoder;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.OptionGroupModel;
import org.apache.tapestry.OptionModel;
import org.apache.tapestry.SelectModel;
import org.apache.tapestry.ValidationException;
import org.apache.tapestry.ValidationTracker;
import org.apache.tapestry.ValueEncoder;
import org.apache.tapestry.annotations.AfterRender;
import org.apache.tapestry.annotations.BeforeRenderTemplate;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.corelib.base.AbstractField;
import org.apache.tapestry.internal.services.FormParameterLookup;
import org.apache.tapestry.services.FieldValidatorDefaultSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Select
extends AbstractField {
    @Parameter(required=true, principal=true)
    private Object _value;
    @Parameter
    private ValueEncoder _encoder = new ValueEncoder<String>(){

        @Override
        public String toClient(String value) {
            return value;
        }

        @Override
        public String toValue(String primaryKey) {
            return primaryKey;
        }
    };
    @Parameter(required=true)
    private SelectModel _model;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> _validate = NOOP_VALIDATOR;
    @Inject(value="infrastructure:FieldValidatorDefaultSource")
    private FieldValidatorDefaultSource _fieldValidatorDefaultSource;
    @Environmental
    private ValidationTracker _tracker;
    @Inject
    private ComponentResources _resources;
    @Inject
    private Locale _locale;

    Binding defaultValue() {
        return this.createDefaultParameterBinding("value");
    }

    FieldValidator defaultValidate() {
        Class type = this._resources.getBoundType("value");
        if (type == null) {
            return null;
        }
        return this._fieldValidatorDefaultSource.createDefaultValidator(this, this._resources.getId(), this._resources.getContainerMessages(), this._locale, type, this._resources.getAnnotationProvider("value"));
    }

    ValueEncoder defaultEncoder() {
        Class valueType = this._resources.getBoundType("value");
        if (valueType == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(valueType)) {
            return new EnumValueEncoder(valueType);
        }
        return null;
    }

    SelectModel defaultModel() {
        Class valueType = this._resources.getBoundType("value");
        if (valueType == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(valueType)) {
            return new EnumSelectModel(valueType, this._resources.getContainerMessages());
        }
        return null;
    }

    void beginRender(MarkupWriter writer) {
        writer.element("select", "name", this.getElementName(), "id", this.getClientId());
    }

    @BeforeRenderTemplate
    void options(MarkupWriter writer) {
        if (this._model.getOptionGroups() != null) {
            for (OptionGroupModel group : this._model.getOptionGroups()) {
                this.writeOptionGroup(writer, group);
            }
        }
        this.writeOptions(writer, this._model.getOptions());
    }

    private void writeOptionGroup(MarkupWriter writer, OptionGroupModel model) {
        writer.element("optgroup", "label", model.getLabel());
        this.writeDisabled(writer, model.isDisabled());
        this.writeAttributes(writer, model.getAttributes());
        this.writeOptions(writer, model.getOptions());
        writer.end();
    }

    private void writeOptions(MarkupWriter writer, List<OptionModel> optionModels) {
        if (optionModels == null) {
            return;
        }
        for (OptionModel model : optionModels) {
            Object optionValue = model.getValue();
            String clientValue = this._encoder.toClient(optionValue);
            writer.element("option", "value", clientValue);
            if (this.isOptionValueSelected(optionValue)) {
                writer.attributes("selected", "selected");
            }
            this.writeDisabled(writer, model.isDisabled());
            this.writeAttributes(writer, model.getAttributes());
            writer.write(model.getLabel());
            writer.end();
        }
    }

    boolean isOptionValueSelected(Object optionValue) {
        return this._value == optionValue || this._value != null && this._value.equals(optionValue);
    }

    private void writeDisabled(MarkupWriter writer, boolean disabled) {
        if (disabled) {
            writer.attributes("disabled", "disabled");
        }
    }

    private void writeAttributes(MarkupWriter writer, Map<String, String> attributes) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            writer.attributes(e.getKey(), e.getValue());
        }
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    @Override
    protected void processSubmission(FormParameterLookup paramLookup, String elementName) {
        String primaryKey = paramLookup.getParameter(elementName);
        Object selectedValue = this._encoder.toValue(primaryKey);
        try {
            this._validate.validate(selectedValue);
            this._value = selectedValue;
        }
        catch (ValidationException ex) {
            this._tracker.recordError(this, ex.getMessage());
            return;
        }
    }

    void setValue(Object value) {
        this._value = value;
    }

    void setModel(SelectModel model) {
        this._model = model;
    }
}

