/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.dom;

import java.io.PrintWriter;
import org.apache.tapestry.dom.DefaultMarkupModel;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.dom.MarkupModel;
import org.apache.tapestry.dom.Node;
import org.apache.tapestry.ioc.internal.util.Defense;

public final class Document
extends Node {
    private Element _rootElement;
    private final MarkupModel _model;

    public Document(MarkupModel model) {
        super(null);
        this._model = model;
    }

    Document getDocument() {
        return this;
    }

    public Element find(String path) {
        String rootElementName;
        Defense.notBlank((String)path, (String)"path");
        if (this._rootElement == null) {
            return null;
        }
        int slashx = path.indexOf("/");
        String string = rootElementName = slashx < 0 ? path : path.substring(0, slashx);
        if (!this._rootElement.getName().equals(rootElementName)) {
            return null;
        }
        return slashx < 0 ? this._rootElement : this._rootElement.find(path.substring(slashx + 1));
    }

    public Document() {
        this(new DefaultMarkupModel());
    }

    public MarkupModel getMarkupModel() {
        return this._model;
    }

    public Element newRootElement(String name) {
        this._rootElement = new Element(this, name);
        return this._rootElement;
    }

    public void toMarkup(PrintWriter writer) {
        if (this._rootElement == null) {
            throw new IllegalStateException("No root element has been defined.");
        }
        this._rootElement.toMarkup(writer);
    }

    public String toString() {
        if (this._rootElement == null) {
            return "[empty Document]";
        }
        return super.toString();
    }

    public Element getRootElement() {
        return this._rootElement;
    }

    public Element getElementById(String id) {
        return this._rootElement.getElementById(id);
    }
}

