/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.dom;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.dom.Comment;
import org.apache.tapestry.dom.Document;
import org.apache.tapestry.dom.EndTagStyle;
import org.apache.tapestry.dom.Node;
import org.apache.tapestry.dom.Text;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Element
extends Node {
    private final String _name;
    private Map<String, String> _attributes;
    private Element _parent;
    private final Document _document;

    Element(Document container, String name) {
        super(container);
        this._document = container;
        this._name = name;
    }

    Element(Element parent, String name) {
        super(parent);
        this._parent = parent;
        this._name = name;
        this._document = parent.getDocument();
    }

    public Document getDocument() {
        return this._document;
    }

    public Element getParent() {
        return this._parent;
    }

    public void attribute(String name, String value) {
        Defense.notBlank((String)name, (String)"name");
        if (value == null) {
            return;
        }
        if (this._attributes == null) {
            this._attributes = CollectionFactory.newMap();
        }
        if (!this._attributes.containsKey(name)) {
            this._attributes.put(name, value);
        }
    }

    public void attributes(String ... namesAndValues) {
        int i = 0;
        while (i < namesAndValues.length) {
            String name = namesAndValues[i++];
            String value = namesAndValues[i++];
            this.attribute(name, value);
        }
    }

    public void forceAttributes(String ... namesAndValues) {
        if (this._attributes == null) {
            this._attributes = CollectionFactory.newMap();
        }
        int i = 0;
        while (i < namesAndValues.length) {
            String value;
            String name = namesAndValues[i++];
            if ((value = namesAndValues[i++]) == null) {
                this._attributes.remove(name);
                continue;
            }
            this._attributes.put(name, value);
        }
    }

    public Element element(String name, String ... namesAndValues) {
        Defense.notBlank((String)name, (String)"name");
        Element child = this.newChild(new Element(this, name));
        child.attributes(namesAndValues);
        return child;
    }

    public Element elementAt(int index, String name, String ... namesAndValues) {
        Defense.notBlank((String)name, (String)"name");
        Element child = new Element(this, name);
        child.attributes(namesAndValues);
        this.insertChildAt(index, child);
        return child;
    }

    public Comment comment(String text) {
        return this.newChild(new Comment(this, text));
    }

    public Text text(String text) {
        return this.newChild(new Text(this, this._document, text));
    }

    private <T extends Node> T newChild(T child) {
        this.addChild(child);
        return child;
    }

    @Override
    public void toMarkup(PrintWriter writer) {
        writer.printf("<%s", this._name);
        if (this._attributes != null) {
            List keys = CollectionFactory.newList(this._attributes.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                String value = this._attributes.get(key);
                writer.printf(" %s=\"%s\"", key, value);
            }
        }
        EndTagStyle style = this._document.getMarkupModel().getEndTagStyle(this._name);
        boolean hasChildren = this.hasChildren();
        String close = !hasChildren && style == EndTagStyle.ABBREVIATE ? "/>" : ">";
        writer.print(close);
        if (hasChildren) {
            this.writeChildMarkup(writer);
        }
        if (style == EndTagStyle.OMIT) {
            return;
        }
        if (hasChildren || style == EndTagStyle.REQUIRE) {
            writer.printf("</%s>", this._name);
        }
    }

    public Element getElementById(String id) {
        Defense.notNull((Object)id, (String)"id");
        LinkedList queue = CollectionFactory.newLinkedList();
        queue.add(this);
        while (!queue.isEmpty()) {
            Element e = (Element)queue.removeFirst();
            String elementId = e.getAttribute("id");
            if (id.equals(elementId)) {
                return e;
            }
            for (Node n : e.getChildren()) {
                Element child = n.asElement();
                if (child == null) continue;
                queue.addLast(child);
            }
        }
        return null;
    }

    public Element find(String path) {
        String name;
        Defense.notBlank((String)path, (String)"path");
        Element search = this;
        String[] arr$ = path.split("/");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (search = search.findChildWithElementName(name = arr$[i$])) != null; ++i$) {
        }
        return search;
    }

    private Element findChildWithElementName(String name) {
        for (Node node : this.getChildren()) {
            Element child = node.asElement();
            if (child == null || !child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public String getAttribute(String attributeName) {
        return (String)InternalUtils.get(this._attributes, (Object)attributeName);
    }

    public String getName() {
        return this._name;
    }

    @Override
    Element asElement() {
        return this;
    }
}

