/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal;

import org.apache.tapestry.BaseValidationDecorator;
import org.apache.tapestry.Field;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.ValidationTracker;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.services.Environment;

public final class DefaultValidationDecorator
extends BaseValidationDecorator {
    private final Environment _environment;

    public DefaultValidationDecorator(Environment environment) {
        this._environment = environment;
    }

    public void insideField(Field field) {
        if (this.inError(field)) {
            this.addErrorClassToCurrentElement();
        }
    }

    public void insideLabel(Field field, Element element) {
        if (field == null) {
            return;
        }
        if (this.inError(field)) {
            this.addErrorClass(element);
        }
    }

    private boolean inError(Field field) {
        ValidationTracker tracker = this._environment.peekRequired(ValidationTracker.class);
        return tracker.inError(field);
    }

    private void addErrorClassToCurrentElement() {
        MarkupWriter writer = this._environment.peekRequired(MarkupWriter.class);
        Element element = writer.getElement();
        this.addErrorClass(element);
    }

    private void addErrorClass(Element element) {
        String current = element.getAttribute("class");
        String newValue = current == null ? "t-error" : current + " " + "t-error";
        element.forceAttributes("class", newValue);
    }
}

