/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.beaneditor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.beaneditor.BeanEditorModel;
import org.apache.tapestry.beaneditor.Order;
import org.apache.tapestry.beaneditor.PropertyConduit;
import org.apache.tapestry.beaneditor.PropertyEditModel;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.internal.beaneditor.BeanEditorMessages;
import org.apache.tapestry.internal.beaneditor.PropertyEditModelImpl;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry.ioc.services.PropertyAdapter;
import org.apache.tapestry.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEditorModelImpl
implements BeanEditorModel,
Comparator<PropertyEditModel> {
    private final Class _beanType;
    private final ClassPropertyAdapter _classPropertyAdapter;
    private final TypeCoercer _typeCoercer;
    private final Messages _messages;
    private final Map<String, PropertyEditModel> _properties = CollectionFactory.newMap();

    public BeanEditorModelImpl(Class beanType, ClassPropertyAdapter classPropertyAdapter, TypeCoercer typeCoercer, Messages messages) {
        this._beanType = beanType;
        this._classPropertyAdapter = classPropertyAdapter;
        this._typeCoercer = typeCoercer;
        this._messages = messages;
    }

    @Override
    public PropertyEditModel add(String propertyName) {
        Order annotation;
        if (this._properties.containsKey(propertyName)) {
            throw new RuntimeException(BeanEditorMessages.duplicatePropertyName(this._beanType, propertyName));
        }
        String label = this.defaultLabel(propertyName);
        PropertyAdapter adapter = this._classPropertyAdapter.getPropertyAdapter(propertyName);
        PropertyConduit conduit = this.defaultConduit(adapter);
        PropertyEditModel propertyModel = new PropertyEditModelImpl(this, propertyName).label(label).conduit(conduit);
        if (adapter != null) {
            propertyModel.propertyType(adapter.getType());
        }
        if (conduit != null && (annotation = conduit.getAnnotation(Order.class)) != null) {
            propertyModel.order(annotation.value());
        }
        this._properties.put(propertyName, propertyModel);
        return propertyModel;
    }

    private PropertyConduit defaultConduit(final PropertyAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        final Class propertyType = adapter.getType();
        return new PropertyConduit(){

            @Override
            public Object get(Object instance) {
                return adapter.get(instance);
            }

            @Override
            public void set(Object instance, Object value) {
                Object coerced = BeanEditorModelImpl.this._typeCoercer.coerce(value, propertyType);
                adapter.set(instance, coerced);
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                T result = this.getAnnotation(adapter.getWriteMethod(), annotationClass);
                if (result == null) {
                    result = this.getAnnotation(adapter.getReadMethod(), annotationClass);
                }
                return result;
            }

            private <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
                return method == null ? null : (T)method.getAnnotation(annotationClass);
            }
        };
    }

    public PropertyEditModel edit(String propertyName) {
        PropertyEditModel propertyModel = this._properties.get(propertyName);
        if (propertyModel == null) {
            throw new RuntimeException(BeanEditorMessages.unknownProperty(this._beanType, propertyName, this._properties.keySet()));
        }
        return propertyModel;
    }

    @Override
    public PropertyEditModel get(String propertyName) {
        return this.edit(propertyName);
    }

    @Override
    public List<String> getPropertyNames() {
        List propertyModels = CollectionFactory.newList(this._properties.values());
        Collections.sort(propertyModels, this);
        List result = CollectionFactory.newList();
        for (PropertyEditModel propertyModel : propertyModels) {
            result.add(propertyModel.getPropertyName());
        }
        return result;
    }

    @Override
    public int compare(PropertyEditModel o1, PropertyEditModel o2) {
        int result = o1.getOrder() - o2.getOrder();
        if (result == 0) {
            result = o1.getPropertyName().compareTo(o2.getPropertyName());
        }
        return result;
    }

    private String defaultLabel(String propertyName) {
        String key = propertyName + "-label";
        if (this._messages.contains(key)) {
            return this._messages.get(key);
        }
        return TapestryUtils.toUserPresentable(propertyName);
    }
}

