/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.internal.model.ModelMessages;
import org.apache.tapestry.internal.model.MutableEmbeddedComponentModelImpl;
import org.apache.tapestry.internal.model.ParameterModelImpl;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.IdAllocator;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.model.EmbeddedComponentModel;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.model.MutableEmbeddedComponentModel;
import org.apache.tapestry.model.ParameterModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableComponentModelImpl
implements MutableComponentModel {
    private final ComponentModel _parentModel;
    private final Resource _baseResource;
    private final String _componentClassName;
    private final IdAllocator _persistentFieldNameAllocator = new IdAllocator();
    private final Log _log;
    private Map<String, ParameterModel> _parameters;
    private Map<String, EmbeddedComponentModel> _embeddedComponents;
    private Map<String, String> _persistentFields;
    private List<String> _mixinClassNames;
    private boolean _informalParametersSupported;
    private boolean _mixinAfter;
    private Map<String, String> _metaData;

    public MutableComponentModelImpl(String componentClassName, Log log, Resource baseResource, ComponentModel parentModel) {
        this._componentClassName = componentClassName;
        this._log = log;
        this._baseResource = baseResource;
        this._parentModel = parentModel;
        if (this._parentModel != null) {
            for (String name : this._parentModel.getPersistentFieldNames()) {
                this._persistentFieldNameAllocator.allocateId(name);
            }
        }
    }

    public String toString() {
        return String.format("ComponentModel[%s]", this._componentClassName);
    }

    @Override
    public Log getLog() {
        return this._log;
    }

    @Override
    public Resource getBaseResource() {
        return this._baseResource;
    }

    @Override
    public String getComponentClassName() {
        return this._componentClassName;
    }

    @Override
    public void addParameter(String name, boolean required, String defaultBindingPrefix) {
        Defense.notBlank((String)name, (String)"name");
        Defense.notBlank((String)defaultBindingPrefix, (String)"defaultBindingPrefix");
        String caseless = name.toLowerCase();
        if (this._parameters == null) {
            this._parameters = CollectionFactory.newMap();
        } else if (this._parameters.containsKey(caseless)) {
            throw new IllegalArgumentException(ModelMessages.duplicateParameter(name, this._componentClassName));
        }
        this._parameters.put(caseless, new ParameterModelImpl(name, required, defaultBindingPrefix));
    }

    @Override
    public ParameterModel getParameterModel(String parameterName) {
        ParameterModel result = (ParameterModel)InternalUtils.get(this._parameters, (Object)parameterName.toLowerCase());
        if (result == null && this._parentModel != null) {
            result = this._parentModel.getParameterModel(parameterName);
        }
        return result;
    }

    @Override
    public List<String> getParameterNames() {
        List names = CollectionFactory.newList();
        if (this._parameters != null) {
            names.addAll(this._parameters.keySet());
        }
        if (this._parentModel != null) {
            names.addAll(this._parentModel.getParameterNames());
        }
        Collections.sort(names);
        return names;
    }

    @Override
    public List<String> getDeclaredParameterNames() {
        return InternalUtils.sortedKeys(this._parameters);
    }

    @Override
    public MutableEmbeddedComponentModel addEmbeddedComponent(String id, String type, String componentClassName) {
        if (this._embeddedComponents == null) {
            this._embeddedComponents = CollectionFactory.newMap();
        } else if (this._embeddedComponents.containsKey(id)) {
            throw new IllegalArgumentException(ModelMessages.duplicateComponentId(id, this._componentClassName));
        }
        MutableEmbeddedComponentModelImpl embedded = new MutableEmbeddedComponentModelImpl(id, type, componentClassName, this._componentClassName);
        this._embeddedComponents.put(id, embedded);
        return embedded;
    }

    @Override
    public List<String> getEmbeddedComponentIds() {
        List result = CollectionFactory.newList();
        if (this._embeddedComponents != null) {
            result.addAll(this._embeddedComponents.keySet());
        }
        if (this._parentModel != null) {
            result.addAll(this._parentModel.getEmbeddedComponentIds());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public EmbeddedComponentModel getEmbeddedComponentModel(String componentId) {
        EmbeddedComponentModel result = (EmbeddedComponentModel)InternalUtils.get(this._embeddedComponents, (Object)componentId);
        if (result == null && this._parentModel != null) {
            result = this._parentModel.getEmbeddedComponentModel(componentId);
        }
        return result;
    }

    @Override
    public String getFieldPersistenceStrategy(String fieldName) {
        String result = (String)InternalUtils.get(this._persistentFields, (Object)fieldName);
        if (result == null && this._parentModel != null) {
            result = this._parentModel.getFieldPersistenceStrategy(fieldName);
        }
        if (result == null) {
            throw new IllegalArgumentException(ModelMessages.missingPersistentField(fieldName));
        }
        return result;
    }

    @Override
    public List<String> getPersistentFieldNames() {
        return this._persistentFieldNameAllocator.getAllocatedIds();
    }

    @Override
    public String setFieldPersistenceStrategy(String fieldName, String strategy) {
        String stripped = InternalUtils.stripMemberPrefix((String)fieldName);
        String logicalFieldName = this._persistentFieldNameAllocator.allocateId(stripped);
        if (this._persistentFields == null) {
            this._persistentFields = CollectionFactory.newMap();
        }
        this._persistentFields.put(logicalFieldName, strategy);
        return logicalFieldName;
    }

    @Override
    public boolean isRootClass() {
        return this._parentModel == null;
    }

    @Override
    public void addMixinClassName(String mixinClassName) {
        if (this._mixinClassNames == null) {
            this._mixinClassNames = CollectionFactory.newList();
        }
        this._mixinClassNames.add(mixinClassName);
    }

    @Override
    public List<String> getMixinClassNames() {
        List result = CollectionFactory.newList();
        if (this._mixinClassNames != null) {
            result.addAll(this._mixinClassNames);
        }
        if (this._parentModel != null) {
            result.addAll(this._parentModel.getMixinClassNames());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void enableSupportsInformalParameters() {
        this._informalParametersSupported = true;
    }

    @Override
    public boolean getSupportsInformalParameters() {
        return this._informalParametersSupported;
    }

    @Override
    public ComponentModel getParentModel() {
        return this._parentModel;
    }

    @Override
    public boolean isMixinAfter() {
        return this._mixinAfter;
    }

    @Override
    public void setMixinAfter(boolean mixinAfter) {
        this._mixinAfter = mixinAfter;
    }

    @Override
    public void setMeta(String key, String value) {
        Defense.notBlank((String)key, (String)"key");
        Defense.notBlank((String)value, (String)"value");
        if (this._metaData == null) {
            this._metaData = CollectionFactory.newMap();
        }
        this._metaData.put(key, value);
    }

    @Override
    public String getMeta(String key) {
        String result = (String)InternalUtils.get(this._metaData, (Object)key);
        if (result == null && this._parentModel != null) {
            result = this._parentModel.getMeta(key);
        }
        return result;
    }
}

