/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.internal.model.ModelMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.MutableEmbeddedComponentModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableEmbeddedComponentModelImpl
implements MutableEmbeddedComponentModel {
    private final String _id;
    private final String _componentType;
    private final String _componentClassName;
    private final String _declaredClass;
    private Map<String, String> _parameters;
    private List<String> _mixinClassNames;

    public MutableEmbeddedComponentModelImpl(String id, String componentType, String componentClassName, String declaredClass) {
        this._id = id;
        this._componentType = componentType;
        this._componentClassName = componentClassName;
        this._declaredClass = declaredClass;
    }

    @Override
    public String getComponentClassName() {
        return this._componentClassName;
    }

    public String toString() {
        return String.format("EmbeddedComponentModel[id=%s type=%s class=%s]", this._id, this._componentType, this._componentClassName);
    }

    @Override
    public void addParameter(String name, String value) {
        if (this._parameters == null) {
            this._parameters = CollectionFactory.newMap();
        } else if (this._parameters.containsKey(name)) {
            throw new IllegalArgumentException(ModelMessages.duplicateParameterValue(name, this._id, this._declaredClass));
        }
        this._parameters.put(name, value);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getComponentType() {
        return this._componentType;
    }

    @Override
    public List<String> getParameterNames() {
        return InternalUtils.sortedKeys(this._parameters);
    }

    @Override
    public String getParameterValue(String parameterName) {
        return (String)InternalUtils.get(this._parameters, (Object)parameterName);
    }

    @Override
    public List<String> getMixinClassNames() {
        if (this._mixinClassNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._mixinClassNames);
    }

    @Override
    public void addMixin(String mixinClassName) {
        if (this._mixinClassNames == null) {
            this._mixinClassNames = CollectionFactory.newList();
        } else if (this._mixinClassNames.contains(mixinClassName)) {
            throw new IllegalArgumentException(ModelMessages.duplicateMixin(mixinClassName, this._id));
        }
        this._mixinClassNames.add(mixinClassName);
    }
}

