/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.internal.services.PersistentFieldChangeImpl;
import org.apache.tapestry.internal.services.SessionHolder;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.services.PersistentFieldChange;
import org.apache.tapestry.services.PersistentFieldStrategy;
import org.apache.tapestry.services.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionPersistentFieldStrategy
implements PersistentFieldStrategy {
    private final String _prefix;
    private final SessionHolder _sessionHolder;

    protected AbstractSessionPersistentFieldStrategy(String prefix, SessionHolder sessionHolder) {
        this._prefix = prefix;
        this._sessionHolder = sessionHolder;
    }

    @Override
    public final Collection<PersistentFieldChange> gatherFieldChanges(String pageName) {
        Session session = this._sessionHolder.getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        List result = CollectionFactory.newList();
        String fullPrefix = this._prefix + pageName + ":";
        for (String name : session.getAttributeNames(fullPrefix)) {
            PersistentFieldChange change = this.buildChange(name, session.getAttribute(name));
            result.add(change);
            this.didReadChange(session, name);
        }
        return result;
    }

    protected void didReadChange(Session session, String attributeName) {
    }

    private PersistentFieldChange buildChange(String name, Object attribute) {
        String[] chunks = name.split(":");
        String componentId = chunks[2];
        String fieldName = chunks[3];
        return new PersistentFieldChangeImpl(componentId, fieldName, attribute);
    }

    @Override
    public final void postChange(String pageName, String componentId, String fieldName, Object newValue) {
        Defense.notBlank((String)pageName, (String)"pageName");
        Defense.notBlank((String)fieldName, (String)"fieldName");
        StringBuilder builder = new StringBuilder(this._prefix);
        builder.append(pageName);
        builder.append(':');
        if (componentId != null) {
            builder.append(componentId);
        }
        builder.append(':');
        builder.append(fieldName);
        Session session = this._sessionHolder.getSession(true);
        session.setAttribute(builder.toString(), newValue);
    }
}

