/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.ComponentEventHandler;
import org.apache.tapestry.Link;
import org.apache.tapestry.internal.services.ActionLinkHandler;
import org.apache.tapestry.internal.services.ActionLinkTarget;
import org.apache.tapestry.internal.services.ComponentInvocation;
import org.apache.tapestry.internal.services.InvocationTarget;
import org.apache.tapestry.internal.services.LinkActionResponseGenerator;
import org.apache.tapestry.internal.services.LinkFactory;
import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.internal.util.Holder;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.ActionResponseGenerator;
import org.apache.tapestry.services.ComponentEventResultProcessor;

public class ActionLinkHandlerImpl
implements ActionLinkHandler {
    private final ComponentEventResultProcessor _resultProcessor;
    private final RequestPageCache _cache;
    private final LinkFactory _linkFactory;

    public ActionLinkHandlerImpl(ComponentEventResultProcessor resultProcessor, RequestPageCache cache, LinkFactory linkFactory) {
        this._resultProcessor = resultProcessor;
        this._cache = cache;
        this._linkFactory = linkFactory;
    }

    public ActionResponseGenerator handle(String logicalPageName, String nestedComponentId, String eventType, String[] context) {
        ActionLinkTarget actionLinkTarget = new ActionLinkTarget(eventType, logicalPageName, nestedComponentId);
        ComponentInvocation invocation = new ComponentInvocation(actionLinkTarget, context);
        return this.handle(invocation);
    }

    public ActionResponseGenerator handle(ComponentInvocation invocation) {
        InvocationTarget target = invocation.getTarget();
        ActionLinkTarget actionLinkTarget = (ActionLinkTarget)Defense.cast((Object)target, ActionLinkTarget.class, (String)"target");
        Page page = this._cache.get(actionLinkTarget.getPageName());
        ComponentPageElement element = page.getComponentElementByNestedId(actionLinkTarget.getComponentNestedId());
        final Holder holder = new Holder();
        ComponentEventHandler handler = new ComponentEventHandler(){

            public boolean handleResult(Object result, Component component, String methodDescription) {
                ActionResponseGenerator generator = ActionLinkHandlerImpl.this._resultProcessor.processComponentEvent(result, component, methodDescription);
                holder.put(generator);
                return true;
            }
        };
        element.triggerEvent(actionLinkTarget.getAction(), invocation.getContext(), handler);
        ActionResponseGenerator result = (ActionResponseGenerator)holder.get();
        if (result == null) {
            Link link = this._linkFactory.createPageLink(page);
            return new LinkActionResponseGenerator(link);
        }
        return result;
    }
}

