/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.IOException;
import java.net.URL;
import org.apache.tapestry.internal.services.ResourceCache;
import org.apache.tapestry.internal.services.ResourceStreamer;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.ClasspathResource;
import org.apache.tapestry.services.ClasspathAssetAliasManager;
import org.apache.tapestry.services.Dispatcher;
import org.apache.tapestry.services.Request;
import org.apache.tapestry.services.Response;

public class AssetDispatcher
implements Dispatcher {
    private final ResourceStreamer _streamer;
    private final ClasspathAssetAliasManager _aliasManager;
    private final ResourceCache _resourceCache;
    static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";

    public AssetDispatcher(ResourceStreamer streamer, ClasspathAssetAliasManager aliasManager, ResourceCache resourceCache) {
        this._streamer = streamer;
        this._aliasManager = aliasManager;
        this._resourceCache = resourceCache;
    }

    public boolean dispatch(Request request, Response response) throws IOException {
        String path = request.getPath();
        if (!path.startsWith("/assets/")) {
            return false;
        }
        String resourcePath = this._aliasManager.toResourcePath(path);
        Resource resource = this.findResourceAndValidateDigest(response, resourcePath);
        if (resource == null) {
            return true;
        }
        URL url = resource.toURL();
        if (url == null) {
            response.sendError(404, ServicesMessages.assetDoesNotExist(resource));
            return true;
        }
        long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE_HEADER);
        if (ifModifiedSince > 0L && ifModifiedSince >= this._resourceCache.getTimeModified(resource)) {
            response.sendError(304, "");
            return true;
        }
        this._streamer.streamResource(resource);
        return true;
    }

    private Resource findResourceAndValidateDigest(Response response, String resourcePath) throws IOException {
        int prevdotx;
        ClasspathResource resource = new ClasspathResource(resourcePath);
        if (!this._resourceCache.requiresDigest((Resource)resource)) {
            return resource;
        }
        String file = resource.getFile();
        boolean valid = false;
        ClasspathResource result = resource;
        int lastdotx = file.lastIndexOf(46);
        if (lastdotx > 0 && (prevdotx = file.lastIndexOf(46, lastdotx - 1)) > 0) {
            String requestDigest = file.substring(prevdotx + 1, lastdotx);
            String realFile = file.substring(0, prevdotx) + file.substring(lastdotx);
            result = resource.forFile(realFile);
            String actualDigest = this._resourceCache.getDigest((Resource)result);
            valid = requestDigest.equals(actualDigest);
        }
        if (!valid) {
            response.sendError(403, ServicesMessages.wrongAssetDigest((Resource)result));
            result = null;
        }
        return result;
    }
}

