/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Map;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.beaneditor.BeanEditorModel;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.beaneditor.BeanEditorModelImpl;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.ioc.services.PropertyAdapter;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.ioc.util.StrategyRegistry;
import org.apache.tapestry.services.BeanEditorModelSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEditorModelSourceImpl
implements BeanEditorModelSource,
InvalidationListener {
    private final TypeCoercer _typeCoercer;
    private final PropertyAccess _propertyAccess;
    private final StrategyRegistry<String> _registry;

    public BeanEditorModelSourceImpl(TypeCoercer typeCoercer, PropertyAccess propertyAccess, Map<Class, String> configuration) {
        this._typeCoercer = typeCoercer;
        this._propertyAccess = propertyAccess;
        this._registry = StrategyRegistry.newInstance(String.class, configuration);
    }

    @Override
    public void objectWasInvalidated() {
        this._registry.clearCache();
    }

    @Override
    public BeanEditorModel create(Class beanClass, ComponentResources resources) {
        Defense.notNull((Object)beanClass, (String)"beanClass");
        Defense.notNull((Object)resources, (String)"resources");
        Messages messages = resources.getMessages();
        ClassPropertyAdapter adapter = this._propertyAccess.getAdapter(beanClass);
        BeanEditorModelImpl model = new BeanEditorModelImpl(beanClass, adapter, this._typeCoercer, messages);
        for (String propertyName : adapter.getPropertyNames()) {
            String editorType;
            PropertyAdapter pa = adapter.getPropertyAdapter(propertyName);
            if (!pa.isRead() || !pa.isUpdate() || (editorType = (String)this._registry.get(pa.getType())).equals("")) continue;
            model.add(propertyName).editorType(editorType);
        }
        return model;
    }
}

