/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.IOException;
import org.apache.tapestry.internal.services.UpdateListenerHub;
import org.apache.tapestry.internal.util.Holder;
import org.apache.tapestry.ioc.internal.util.ConcurrentBarrier;
import org.apache.tapestry.ioc.internal.util.Invokable;
import org.apache.tapestry.services.Request;
import org.apache.tapestry.services.RequestFilter;
import org.apache.tapestry.services.RequestHandler;
import org.apache.tapestry.services.Response;

public class CheckForUpdatesFilter
implements RequestFilter {
    private long _lastCheck = 0L;
    private final long _checkInterval;
    private final UpdateListenerHub _updateListenerHub;
    private final ConcurrentBarrier _barrier = new ConcurrentBarrier();
    private final Runnable _checker = new Runnable(){

        public void run() {
            if (System.currentTimeMillis() - CheckForUpdatesFilter.this._lastCheck >= CheckForUpdatesFilter.this._checkInterval) {
                CheckForUpdatesFilter.this._updateListenerHub.fireUpdateEvent();
                CheckForUpdatesFilter.this._lastCheck = System.currentTimeMillis();
            }
        }
    };

    public CheckForUpdatesFilter(UpdateListenerHub updateListenerHub, long checkInterval) {
        this._updateListenerHub = updateListenerHub;
        this._checkInterval = checkInterval;
    }

    public boolean service(final Request request, final Response response, final RequestHandler handler) throws IOException {
        final Holder exceptionHolder = new Holder();
        Invokable<Boolean> invokable = new Invokable<Boolean>(){

            public Boolean invoke() {
                if (System.currentTimeMillis() - CheckForUpdatesFilter.this._lastCheck >= CheckForUpdatesFilter.this._checkInterval) {
                    CheckForUpdatesFilter.this._barrier.withWrite(CheckForUpdatesFilter.this._checker);
                }
                try {
                    return handler.service(request, response);
                }
                catch (IOException ex) {
                    exceptionHolder.put(ex);
                    return false;
                }
            }
        };
        boolean result = (Boolean)this._barrier.withRead((Invokable)invokable);
        IOException ex = (IOException)exceptionHolder.get();
        if (ex != null) {
            throw ex;
        }
        return result;
    }
}

