/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Map;
import org.apache.tapestry.Asset;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.services.ResourceCache;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.ClasspathResource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.AssetFactory;
import org.apache.tapestry.services.ClasspathAssetAliasManager;

public class ClasspathAssetFactory
implements AssetFactory,
InvalidationListener {
    private final ResourceCache _cache;
    private final ClasspathAssetAliasManager _aliasManager;
    private final Map<Resource, String> _resourceToClientURL = CollectionFactory.newThreadSafeMap();

    public ClasspathAssetFactory(ResourceCache cache, ClasspathAssetAliasManager aliasManager) {
        this._cache = cache;
        this._aliasManager = aliasManager;
    }

    public void objectWasInvalidated() {
        this._resourceToClientURL.clear();
    }

    private String clientURL(Resource resource) {
        String clientURL = this._resourceToClientURL.get(resource);
        if (clientURL == null) {
            clientURL = this.buildClientURL(resource);
            this._resourceToClientURL.put(resource, clientURL);
        }
        return clientURL;
    }

    private String buildClientURL(Resource resource) {
        boolean requiresDigest = this._cache.requiresDigest(resource);
        String path = resource.getPath();
        if (requiresDigest) {
            int lastdotx = path.lastIndexOf(46);
            String revisedPath = path.substring(0, lastdotx + 1) + this._cache.getDigest(resource) + path.substring(lastdotx);
            return this._aliasManager.toClientURL(revisedPath);
        }
        return this._aliasManager.toClientURL(path);
    }

    public Asset createAsset(final Resource resource) {
        return new Asset(){

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                return ClasspathAssetFactory.this.clientURL(resource);
            }

            public String toString() {
                return this.toClientURL();
            }
        };
    }

    public Resource getRootResource() {
        return new ClasspathResource("");
    }
}

