/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.InjectionProvider;
import org.apache.tapestry.services.TransformConstants;

public class CommonResourcesInjectionProvider
implements InjectionProvider {
    private static final Map<String, String> _configuration = CollectionFactory.newMap();

    public CommonResourcesInjectionProvider() {
        this.add(Messages.class, "getMessages");
        this.add(Locale.class, "getLocale");
        this.add(Log.class, "getLog");
        this.add(String.class, "getCompleteId");
    }

    private void add(Class fieldType, String methodName) {
        _configuration.put(fieldType.getName(), methodName);
    }

    public boolean provideInjection(String fieldName, String fieldType, ServiceLocator locator, ClassTransformation transformation, MutableComponentModel componentModel) {
        String implementationMethodName = _configuration.get(fieldType);
        if (implementationMethodName == null) {
            return false;
        }
        String resourcesField = transformation.getResourcesFieldName();
        String body = String.format("%s = %s.%s();", fieldName, resourcesField, implementationMethodName);
        transformation.makeReadOnly(fieldName);
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, body);
        return true;
    }
}

