/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.internal.services.ComponentClassLocator;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentClassLocatorImpl
implements ComponentClassLocator {
    private static final String CLASS_SUFFIX = ".class";
    private final ClassLoader _contextClassLoader = Thread.currentThread().getContextClassLoader();

    @Override
    public Collection<String> locateComponentClassNames(String packageName) {
        String packagePath = packageName.replace('.', '/') + "/";
        try {
            return this.findClassesWithinPath(packagePath);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Collection<String> findClassesWithinPath(String packagePath) throws IOException {
        List result = CollectionFactory.newList();
        Enumeration<URL> urls = this._contextClassLoader.getResources(packagePath);
        while (urls.hasMoreElements()) {
            this.scanURL(packagePath, result, urls.nextElement());
        }
        return result;
    }

    private void scanURL(String packagePath, Collection<String> componentClassNames, URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            this.scanJarConnection(packagePath, componentClassNames, (JarURLConnection)connection);
            return;
        }
        LinkedList queue = CollectionFactory.newLinkedList();
        queue.addFirst(new Queued(url, packagePath));
        while (!queue.isEmpty()) {
            Queued queued = (Queued)queue.removeFirst();
            this.scan(queued._packagePath, queued._packageURL, componentClassNames, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(String packagePath, URL packageURL, Collection<String> componentClassNames, LinkedList<Queued> queue) throws IOException {
        BufferedInputStream is = new BufferedInputStream(packageURL.openStream());
        InputStreamReader reader = new InputStreamReader(is);
        LineNumberReader lineReader = new LineNumberReader(reader);
        String packageName = null;
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (line.contains("$")) continue;
                if (line.endsWith(CLASS_SUFFIX)) {
                    if (packageName == null) {
                        packageName = packagePath.replace('/', '.');
                    }
                    String fullClassName = packageName + line.substring(0, line.length() - CLASS_SUFFIX.length());
                    componentClassNames.add(fullClassName);
                    continue;
                }
                if (line.contains(".")) continue;
                URL newURL = new URL(packageURL.toExternalForm() + line + "/");
                String newPackagePath = packagePath + line + "/";
                queue.addFirst(new Queued(newURL, newPackagePath));
            }
            lineReader.close();
            lineReader = null;
        }
        finally {
            TapestryUtils.close(lineReader);
        }
    }

    private void scanJarConnection(String packagePath, Collection<String> componentClassNames, JarURLConnection connection) throws IOException {
        Enumeration<JarEntry> e = connection.getJarFile().entries();
        while (e.hasMoreElements()) {
            String name = e.nextElement().getName();
            if (!name.startsWith(packagePath) || !name.endsWith(CLASS_SUFFIX) || name.contains("$")) continue;
            String className = name.substring(0, name.length() - CLASS_SUFFIX.length()).replace("/", ".");
            componentClassNames.add(className);
        }
    }

    static class Queued {
        final URL _packageURL;
        final String _packagePath;

        public Queued(URL packageURL, String packagePath) {
            this._packageURL = packageURL;
            this._packagePath = packagePath;
        }
    }
}

