/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Map;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.commons.logging.Log;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.model.MutableComponentModelImpl;
import org.apache.tapestry.internal.services.ComponentClassTransformer;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.services.InternalClassTransformation;
import org.apache.tapestry.internal.services.InternalClassTransformationImpl;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.LogSource;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.ClasspathResource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.services.ComponentClassTransformWorker;

public class ComponentClassTransformerImpl
implements ComponentClassTransformer,
InvalidationListener {
    private final Map<String, InternalClassTransformation> _nameToClassTransformation = CollectionFactory.newThreadSafeMap();
    private final Map<String, ComponentModel> _nameToComponentModel = CollectionFactory.newThreadSafeMap();
    private final ComponentClassTransformWorker _workerChain;
    private final LogSource _logSource;

    public ComponentClassTransformerImpl(ComponentClassTransformWorker workerChain, LogSource logSource) {
        this._workerChain = workerChain;
        this._logSource = logSource;
    }

    public void objectWasInvalidated() {
        this._nameToClassTransformation.clear();
        this._nameToComponentModel.clear();
    }

    public void transformComponentClass(CtClass ctClass, ClassLoader classLoader) {
        InternalClassTransformationImpl transformation;
        String parentClassname;
        String classname = ctClass.getName();
        try {
            parentClassname = ctClass.getSuperclass().getName();
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Log log = this._logSource.getLog(classname);
        InternalClassTransformation parentTransformation = this._nameToClassTransformation.get(parentClassname);
        ClasspathResource baseResource = new ClasspathResource(classname.replace(".", "/") + ".class");
        ComponentModel parentModel = this._nameToComponentModel.get(parentClassname);
        MutableComponentModelImpl model = new MutableComponentModelImpl(classname, log, (Resource)baseResource, parentModel);
        InternalClassTransformationImpl internalClassTransformationImpl = transformation = parentTransformation == null ? new InternalClassTransformationImpl(ctClass, classLoader, log, model) : new InternalClassTransformationImpl(ctClass, parentTransformation, classLoader, log, model);
        if (transformation.getAnnotation(ComponentClass.class) == null) {
            return;
        }
        this._workerChain.transform(transformation, model);
        transformation.finish();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished class transformation: " + transformation));
        }
        this._nameToClassTransformation.put(classname, transformation);
        this._nameToComponentModel.put(classname, model);
    }

    public Instantiator createInstantiator(Class componentClass) {
        String className = componentClass.getName();
        InternalClassTransformation ct = this._nameToClassTransformation.get(className);
        if (ct == null) {
            throw new RuntimeException(ServicesMessages.classNotTransformed(className));
        }
        return ct.createInstantiator(componentClass);
    }
}

